/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class TitledBorder
extends AbstractBorder {
    public static final int DEFAULT_POSITION = 0;
    public static final int ABOVE_TOP = 1;
    public static final int TOP = 2;
    public static final int BELOW_TOP = 3;
    public static final int ABOVE_BOTTOM = 4;
    public static final int BOTTOM = 5;
    public static final int BELOW_BOTTOM = 6;
    public static final int DEFAULT_JUSTIFICATION = 0;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public static final int LEADING = 4;
    public static final int TRAILING = 5;
    protected static final int EDGE_SPACING = 2;
    protected static final int TEXT_INSET_H = 5;
    protected static final int TEXT_SPACING = 2;
    static final long serialVersionUID = 8012999415147721601L;
    protected String title;
    protected Border border;
    protected int titlePosition;
    protected int titleJustification;
    protected Font titleFont;
    protected Color titleColor;

    public TitledBorder(String title) {
        this(null, title, 4, 2, null, null);
    }

    public TitledBorder(Border border) {
        this(border, "", 4, 2, null, null);
    }

    public TitledBorder(Border border, String title) {
        this(border, title, 4, 2, null, null);
    }

    public TitledBorder(Border border, String title, int titleJustification, int titlePosition) {
        this(border, title, titleJustification, titlePosition, null, null);
    }

    public TitledBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont) {
        this(border, title, titleJustification, titlePosition, titleFont, null);
    }

    public TitledBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont, Color titleColor) {
        this.border = border;
        this.title = title;
        this.setTitleJustification(titleJustification);
        this.setTitlePosition(titlePosition);
        this.titleFont = titleFont;
        this.titleColor = titleColor;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Rectangle borderRect = new Rectangle(x + 2, y + 2, width - 4, height - 4);
        Point textLoc = new Point();
        Color savedColor = g.getColor();
        Font savedFont = g.getFont();
        Font font = this.getFont(c);
        g.setFont(font);
        FontMetrics fm = c.getFontMetrics(font);
        this.layoutBorderWithTitle(c, fm, borderRect, textLoc);
        this.paintBorderWithTitle(c, g, x, y, width, height, borderRect, textLoc, fm);
        g.setColor(this.getTitleColor());
        g.drawString(this.getTitle(), textLoc.x, textLoc.y);
        g.setFont(savedFont);
        g.setColor(savedColor);
    }

    private void layoutBorderWithTitle(Component c, FontMetrics fm, Rectangle borderRect, Point textLoc) {
        Border b = this.getBorder();
        int fontHeight = fm.getHeight();
        int fontDescent = fm.getDescent();
        int fontAscent = fm.getAscent();
        int titleWidth = fm.stringWidth(this.getTitle());
        Insets insets = b == null ? new Insets(0, 0, 0, 0) : b.getBorderInsets(c);
        int titlePosition = this.getTitlePosition();
        switch (titlePosition) {
            case 4: {
                textLoc.y = borderRect.y + borderRect.height - insets.bottom - fontDescent - 2;
                break;
            }
            case 5: {
                borderRect.height -= fontHeight / 2;
                textLoc.y = borderRect.y + borderRect.height - fontDescent + (fontAscent + fontDescent - insets.bottom) / 2;
                break;
            }
            case 6: {
                borderRect.height -= fontHeight;
                textLoc.y = borderRect.y + borderRect.height + fontAscent + 2;
                break;
            }
            case 1: {
                int offset = fontAscent + fontDescent + Math.max(2, 4) - 2;
                borderRect.y += offset;
                borderRect.height -= offset;
                textLoc.y = borderRect.y - (fontDescent + 2);
                break;
            }
            case 3: {
                textLoc.y = borderRect.y + insets.top + fontAscent + 2;
                break;
            }
            default: {
                int offset = Math.max(0, fontAscent / 2 + 2 - 2);
                borderRect.y += offset;
                borderRect.height -= offset;
                textLoc.y = borderRect.y - fontDescent + (insets.top + fontAscent + fontDescent) / 2;
            }
        }
        int justification = this.getTitleJustification();
        if (c.getComponentOrientation().isLeftToRight()) {
            if (justification == 4 || justification == 0) {
                justification = 1;
            } else if (justification == 5) {
                justification = 3;
            }
        } else if (justification == 4 || justification == 0) {
            justification = 3;
        } else if (justification == 5) {
            justification = 1;
        }
        switch (justification) {
            case 2: {
                textLoc.x = borderRect.x + (borderRect.width - titleWidth) / 2;
                break;
            }
            case 3: {
                textLoc.x = borderRect.x + borderRect.width - titleWidth - 5 - insets.right;
                break;
            }
            default: {
                textLoc.x = borderRect.x + 5 + insets.left;
            }
        }
    }

    private void paintBorderWithTitle(Component c, Graphics g, int x, int y, int width, int height, Rectangle borderRect, Point textLoc, FontMetrics fm) {
        Border b = this.getBorder();
        int fontDescent = fm.getDescent();
        int fontAscent = fm.getAscent();
        int titleWidth = fm.stringWidth(this.getTitle());
        if (b != null) {
            if ((this.titlePosition == 2 || this.titlePosition == 0) && borderRect.y > textLoc.y - fontAscent || this.titlePosition == 5 && borderRect.y + borderRect.height < textLoc.y + fontDescent) {
                Rectangle clip = new Rectangle();
                Rectangle saved = g.getClipBounds();
                clip.setBounds(saved);
                SwingUtilities.computeIntersection(x, y, textLoc.x - x - 1, height, clip);
                if (!clip.isEmpty()) {
                    g.setClip(clip);
                    b.paintBorder(c, g, borderRect.x, borderRect.y, borderRect.width, borderRect.height);
                }
                clip.setBounds(saved);
                SwingUtilities.computeIntersection(textLoc.x + titleWidth + 1, y, x + width - (textLoc.x + titleWidth + 1), height, clip);
                if (!clip.isEmpty()) {
                    g.setClip(clip);
                    b.paintBorder(c, g, borderRect.x, borderRect.y, borderRect.width, borderRect.height);
                }
                if (this.titlePosition == 2 || this.titlePosition == 0) {
                    clip.setBounds(saved);
                    SwingUtilities.computeIntersection(textLoc.x - 1, textLoc.y + fontDescent, titleWidth + 2, y + height - textLoc.y - fontDescent, clip);
                    if (!clip.isEmpty()) {
                        g.setClip(clip);
                        b.paintBorder(c, g, borderRect.x, borderRect.y, borderRect.width, borderRect.height);
                    }
                } else {
                    clip.setBounds(saved);
                    SwingUtilities.computeIntersection(textLoc.x - 1, y, titleWidth + 2, textLoc.y - fontDescent - y, clip);
                    if (!clip.isEmpty()) {
                        g.setClip(clip);
                        b.paintBorder(c, g, borderRect.x, borderRect.y, borderRect.width, borderRect.height);
                    }
                }
                g.setClip(saved);
            } else {
                b.paintBorder(c, g, borderRect.x, borderRect.y, borderRect.width, borderRect.height);
            }
        }
    }

    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        Border border = this.getBorder();
        if (border != null) {
            if (border instanceof AbstractBorder) {
                AbstractBorder aBorder = (AbstractBorder)border;
                aBorder.getBorderInsets(c, insets);
            } else {
                Insets i = border.getBorderInsets(c);
                insets.top = i.top;
                insets.bottom = i.bottom;
                insets.left = i.left;
                insets.right = i.right;
            }
        } else {
            insets.top = 0;
            insets.bottom = 0;
            insets.left = 0;
            insets.right = 0;
        }
        insets.top += 4;
        insets.bottom += 4;
        insets.left += 4;
        insets.right += 4;
        String title = this.getTitle();
        if (c != null && title != null && !title.equals("")) {
            Font font = this.getFont(c);
            FontMetrics fm = c.getFontMetrics(font);
            int ascent = fm.getAscent();
            int descent = fm.getDescent();
            int height = fm.getHeight();
            switch (this.getTitlePosition()) {
                case 4: {
                    insets.bottom += ascent + descent + 2;
                    break;
                }
                case 5: {
                    insets.bottom += ascent + descent;
                    break;
                }
                case 6: {
                    insets.bottom += height;
                    break;
                }
                case 1: {
                    insets.top += ascent + descent + Math.max(2, 4) - 2;
                    break;
                }
                case 3: {
                    insets.top += ascent + descent + 2;
                    break;
                }
                default: {
                    insets.top += ascent + descent;
                }
            }
        }
        return insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public String getTitle() {
        return this.title;
    }

    public Border getBorder() {
        if (this.border != null) {
            return this.border;
        }
        return UIManager.getBorder("TitledBorder.border");
    }

    public int getTitlePosition() {
        return this.titlePosition;
    }

    public int getTitleJustification() {
        return this.titleJustification;
    }

    public Font getTitleFont() {
        if (this.titleFont != null) {
            return this.titleFont;
        }
        return UIManager.getFont("TitledBorder.font");
    }

    public Color getTitleColor() {
        if (this.titleColor != null) {
            return this.titleColor;
        }
        return UIManager.getColor("TitledBorder.titleColor");
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public void setTitlePosition(int titlePosition) {
        if (titlePosition < 0 || titlePosition > 6) {
            throw new IllegalArgumentException(String.valueOf(titlePosition) + " is not a valid title position.");
        }
        this.titlePosition = titlePosition;
    }

    public void setTitleJustification(int titleJustification) {
        if (titleJustification < 0 || titleJustification > 5) {
            throw new IllegalArgumentException(String.valueOf(titleJustification) + " is not a valid title justification.");
        }
        this.titleJustification = titleJustification;
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    public void setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
    }

    public Dimension getMinimumSize(Component c) {
        Insets i = this.getBorderInsets(c);
        Dimension minSize = new Dimension(i.left + i.right, i.top + i.bottom);
        Font font = this.getFont(c);
        FontMetrics fm = c.getFontMetrics(font);
        int titleWidth = fm.stringWidth(this.getTitle());
        switch (this.getTitlePosition()) {
            case 1: 
            case 6: {
                minSize.width = Math.max(minSize.width, titleWidth);
                break;
            }
            default: {
                minSize.width += titleWidth;
            }
        }
        return minSize;
    }

    protected Font getFont(Component c) {
        Font f = this.getTitleFont();
        if (f != null) {
            return f;
        }
        return new Font("Dialog", 0, 12);
    }
}

