/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.EventListener;
import javax.swing.SingleSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSingleSelectionModel
implements SingleSelectionModel,
Serializable {
    private static final long serialVersionUID = 3676229404753786004L;
    protected transient ChangeEvent changeEvent;
    protected EventListenerList listenerList = new EventListenerList();
    private int index = -1;

    @Override
    public int getSelectedIndex() {
        return this.index;
    }

    @Override
    public void setSelectedIndex(int index) {
        if (this.index != index) {
            this.index = index;
            this.fireStateChanged();
        }
    }

    @Override
    public void clearSelection() {
        this.setSelectedIndex(-1);
    }

    @Override
    public boolean isSelected() {
        return this.index != -1;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    protected void fireStateChanged() {
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        ChangeListener[] listeners = this.getChangeListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].stateChanged(this.changeEvent);
            ++i;
        }
    }

    public <T extends EventListener> T[] getListeners(Class<T> listenerClass) {
        return this.listenerList.getListeners(listenerClass);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.getListeners(ChangeListener.class);
    }
}

