/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import gnu.java.lang.CPStringBuilder;
import java.text.CharacterIterator;
import java.text.RuleBasedCollator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;

public final class CollationElementIterator {
    public static final int NULLORDER = -1;
    RuleBasedCollator collator;
    CharacterIterator text;
    int index;
    int textIndex;
    private RuleBasedCollator.CollationElement[] textDecomposition;
    private int[] textIndexes;

    CollationElementIterator(RuleBasedCollator collator, String text) {
        this.collator = collator;
        this.setText(text);
    }

    CollationElementIterator(RuleBasedCollator collator, CharacterIterator text) {
        this.collator = collator;
        this.setText(text);
    }

    RuleBasedCollator.CollationElement nextBlock() {
        if (this.index >= this.textDecomposition.length) {
            return null;
        }
        RuleBasedCollator.CollationElement e = this.textDecomposition[this.index];
        this.textIndex = this.textIndexes[this.index + 1];
        ++this.index;
        return e;
    }

    RuleBasedCollator.CollationElement previousBlock() {
        if (this.index == 0) {
            return null;
        }
        --this.index;
        RuleBasedCollator.CollationElement e = this.textDecomposition[this.index];
        this.textIndex = this.textIndexes[this.index + 1];
        return e;
    }

    public int next() {
        RuleBasedCollator.CollationElement e = this.nextBlock();
        if (e == null) {
            return -1;
        }
        return e.getValue();
    }

    public int previous() {
        RuleBasedCollator.CollationElement e = this.previousBlock();
        if (e == null) {
            return -1;
        }
        return e.getValue();
    }

    public static int primaryOrder(int order) {
        return order >>> 16;
    }

    public void reset() {
        this.index = 0;
        this.textIndex = 0;
    }

    public static short secondaryOrder(int order) {
        return (short)(order >>> 8 & 0xFF);
    }

    public static short tertiaryOrder(int order) {
        return (short)(order & 0xFF);
    }

    public void setText(String text) {
        int idx = 0;
        int idx_idx = 0;
        int alreadyExpanded = 0;
        int idxToMove = 0;
        this.text = new StringCharacterIterator(text);
        this.index = 0;
        String work_text = text.intern();
        ArrayList<RuleBasedCollator.CollationElement> aElement = new ArrayList<RuleBasedCollator.CollationElement>();
        ArrayList<Integer> aIdx = new ArrayList<Integer>();
        while (idx < work_text.length()) {
            RuleBasedCollator.CollationElement prefix;
            RuleBasedCollator.CollationElement object = null;
            int p = 1;
            String key = null;
            String keyOld = null;
            do {
                if (object != null) {
                    keyOld = key;
                }
                if ((object = this.collator.prefix_tree.get(key = work_text.substring(idx, idx + p))) == null || idx >= alreadyExpanded) continue;
                prefix = object;
                if (prefix.expansion == null || !prefix.expansion.startsWith(work_text.substring(0, idx))) continue;
                object = null;
                key = keyOld;
            } while (idx + ++p <= work_text.length());
            if (object == null) {
                key = keyOld;
            }
            if ((prefix = this.collator.prefix_tree.get(key)) == null) {
                RuleBasedCollator.CollationElement e;
                if (alreadyExpanded > 0) {
                    e = this.collator.getDefaultAccentedElement(work_text.charAt(idx));
                    aElement.add(e);
                    aIdx.add(idx_idx);
                    ++idx;
                    if (--alreadyExpanded == 0) {
                        idx_idx += idxToMove;
                        idxToMove = 0;
                        continue;
                    }
                    ++idx_idx;
                    continue;
                }
                e = this.collator.getDefaultElement(work_text.charAt(idx));
                Integer iRef = idx_idx;
                aElement.add(RuleBasedCollator.SPECIAL_UNKNOWN_SEQ);
                aIdx.add(iRef);
                aElement.add(e);
                aIdx.add(iRef);
                ++idx_idx;
                ++idx;
                continue;
            }
            if (prefix.expansion != null) {
                work_text = String.valueOf(prefix.expansion) + work_text.substring(idx + prefix.key.length());
                idx = 0;
                aElement.add(prefix);
                aIdx.add(idx_idx);
                if (alreadyExpanded == 0) {
                    idxToMove = prefix.key.length();
                }
                alreadyExpanded += prefix.expansion.length() - prefix.key.length();
                continue;
            }
            aElement.add(prefix);
            aIdx.add(idx_idx);
            idx += prefix.key.length();
            if (alreadyExpanded > 0) {
                if ((alreadyExpanded -= prefix.key.length()) != 0) continue;
                idx_idx += idxToMove;
                idxToMove = 0;
                continue;
            }
            idx_idx += prefix.key.length();
        }
        this.textDecomposition = aElement.toArray(new RuleBasedCollator.CollationElement[aElement.size()]);
        this.textIndexes = new int[aIdx.size() + 1];
        int i = 0;
        while (i < aIdx.size()) {
            this.textIndexes[i] = (Integer)aIdx.get(i);
            ++i;
        }
        this.textIndexes[aIdx.size()] = text.length();
    }

    public void setText(CharacterIterator source) {
        CPStringBuilder expand = new CPStringBuilder();
        char c = source.first();
        while (c != '\uffff') {
            expand.append(c);
            c = source.next();
        }
        this.setText(expand.toString());
    }

    public int getOffset() {
        return this.textIndex;
    }

    public void setOffset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("Negative offset: " + offset);
        }
        if (offset > this.text.getEndIndex() - 1) {
            throw new IllegalArgumentException("Offset too large: " + offset);
        }
        this.index = 0;
        while (this.index < this.textDecomposition.length) {
            if (offset <= this.textIndexes[this.index]) break;
            ++this.index;
        }
        this.textIndex = this.textIndexes[this.index] == offset ? offset : this.textIndexes[this.index - 1];
    }

    public int getMaxExpansion(int value) {
        return 1;
    }
}

