/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.SSLHMac;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collections;
import java.util.Map;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;

public class SSLv3HMacSHAImpl
extends MacSpi {
    private final SSLHMac adaptee = new SSLHMac("SHA-160");

    protected byte[] engineDoFinal() {
        return this.adaptee.digest();
    }

    protected int engineGetMacLength() {
        return this.adaptee.macSize();
    }

    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (!(key instanceof SecretKey) || !key.getAlgorithm().equalsIgnoreCase("SSLv3HMac-SHA")) {
            throw new InvalidKeyException("expecting secret key with algorithm \"SSLv3HMac-SHA\"");
        }
        Map<String, byte[]> attr = Collections.singletonMap("gnu.crypto.mac.key.material", key.getEncoded());
        this.adaptee.init(attr);
    }

    protected void engineReset() {
        this.adaptee.reset();
    }

    protected void engineUpdate(byte input) {
        this.adaptee.update(input);
    }

    protected void engineUpdate(byte[] input, int offset, int length) {
        this.adaptee.update(input, offset, length);
    }
}

