/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.hash;

import gnu.java.security.hash.BaseHash;
import gnu.java.security.util.Util;

public class RipeMD160
extends BaseHash {
    private static final int BLOCK_SIZE = 64;
    private static final String DIGEST0 = "9C1185A5C5E9FC54612808977EE8F548B2258D31";
    private static final int[] R;
    private static final int[] Rp;
    private static final int[] S;
    private static final int[] Sp;
    private static Boolean valid;
    private int h0;
    private int h1;
    private int h2;
    private int h3;
    private int h4;
    private int[] X = new int[16];

    static {
        int[] nArray = new int[80];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        nArray[12] = 12;
        nArray[13] = 13;
        nArray[14] = 14;
        nArray[15] = 15;
        nArray[16] = 7;
        nArray[17] = 4;
        nArray[18] = 13;
        nArray[19] = 1;
        nArray[20] = 10;
        nArray[21] = 6;
        nArray[22] = 15;
        nArray[23] = 3;
        nArray[24] = 12;
        nArray[26] = 9;
        nArray[27] = 5;
        nArray[28] = 2;
        nArray[29] = 14;
        nArray[30] = 11;
        nArray[31] = 8;
        nArray[32] = 3;
        nArray[33] = 10;
        nArray[34] = 14;
        nArray[35] = 4;
        nArray[36] = 9;
        nArray[37] = 15;
        nArray[38] = 8;
        nArray[39] = 1;
        nArray[40] = 2;
        nArray[41] = 7;
        nArray[43] = 6;
        nArray[44] = 13;
        nArray[45] = 11;
        nArray[46] = 5;
        nArray[47] = 12;
        nArray[48] = 1;
        nArray[49] = 9;
        nArray[50] = 11;
        nArray[51] = 10;
        nArray[53] = 8;
        nArray[54] = 12;
        nArray[55] = 4;
        nArray[56] = 13;
        nArray[57] = 3;
        nArray[58] = 7;
        nArray[59] = 15;
        nArray[60] = 14;
        nArray[61] = 5;
        nArray[62] = 6;
        nArray[63] = 2;
        nArray[64] = 4;
        nArray[66] = 5;
        nArray[67] = 9;
        nArray[68] = 7;
        nArray[69] = 12;
        nArray[70] = 2;
        nArray[71] = 10;
        nArray[72] = 14;
        nArray[73] = 1;
        nArray[74] = 3;
        nArray[75] = 8;
        nArray[76] = 11;
        nArray[77] = 6;
        nArray[78] = 15;
        nArray[79] = 13;
        R = nArray;
        int[] nArray2 = new int[80];
        nArray2[0] = 5;
        nArray2[1] = 14;
        nArray2[2] = 7;
        nArray2[4] = 9;
        nArray2[5] = 2;
        nArray2[6] = 11;
        nArray2[7] = 4;
        nArray2[8] = 13;
        nArray2[9] = 6;
        nArray2[10] = 15;
        nArray2[11] = 8;
        nArray2[12] = 1;
        nArray2[13] = 10;
        nArray2[14] = 3;
        nArray2[15] = 12;
        nArray2[16] = 6;
        nArray2[17] = 11;
        nArray2[18] = 3;
        nArray2[19] = 7;
        nArray2[21] = 13;
        nArray2[22] = 5;
        nArray2[23] = 10;
        nArray2[24] = 14;
        nArray2[25] = 15;
        nArray2[26] = 8;
        nArray2[27] = 12;
        nArray2[28] = 4;
        nArray2[29] = 9;
        nArray2[30] = 1;
        nArray2[31] = 2;
        nArray2[32] = 15;
        nArray2[33] = 5;
        nArray2[34] = 1;
        nArray2[35] = 3;
        nArray2[36] = 7;
        nArray2[37] = 14;
        nArray2[38] = 6;
        nArray2[39] = 9;
        nArray2[40] = 11;
        nArray2[41] = 8;
        nArray2[42] = 12;
        nArray2[43] = 2;
        nArray2[44] = 10;
        nArray2[46] = 4;
        nArray2[47] = 13;
        nArray2[48] = 8;
        nArray2[49] = 6;
        nArray2[50] = 4;
        nArray2[51] = 1;
        nArray2[52] = 3;
        nArray2[53] = 11;
        nArray2[54] = 15;
        nArray2[56] = 5;
        nArray2[57] = 12;
        nArray2[58] = 2;
        nArray2[59] = 13;
        nArray2[60] = 9;
        nArray2[61] = 7;
        nArray2[62] = 10;
        nArray2[63] = 14;
        nArray2[64] = 12;
        nArray2[65] = 15;
        nArray2[66] = 10;
        nArray2[67] = 4;
        nArray2[68] = 1;
        nArray2[69] = 5;
        nArray2[70] = 8;
        nArray2[71] = 7;
        nArray2[72] = 6;
        nArray2[73] = 2;
        nArray2[74] = 13;
        nArray2[75] = 14;
        nArray2[77] = 3;
        nArray2[78] = 9;
        nArray2[79] = 11;
        Rp = nArray2;
        S = new int[]{11, 14, 15, 12, 5, 8, 7, 9, 11, 13, 14, 15, 6, 7, 9, 8, 7, 6, 8, 13, 11, 9, 7, 15, 7, 12, 15, 9, 11, 7, 13, 12, 11, 13, 6, 7, 14, 9, 13, 15, 14, 8, 13, 6, 5, 12, 7, 5, 11, 12, 14, 15, 14, 15, 9, 8, 9, 14, 5, 6, 8, 6, 5, 12, 9, 15, 5, 11, 6, 8, 13, 12, 5, 12, 13, 14, 11, 8, 5, 6};
        Sp = new int[]{8, 9, 9, 11, 13, 15, 15, 5, 7, 7, 8, 11, 14, 14, 12, 6, 9, 13, 15, 7, 12, 8, 9, 11, 7, 7, 12, 7, 6, 15, 13, 11, 9, 7, 15, 11, 8, 6, 6, 14, 12, 13, 5, 14, 13, 13, 7, 5, 15, 5, 8, 11, 14, 14, 6, 14, 6, 9, 12, 9, 12, 5, 15, 8, 8, 5, 12, 9, 12, 5, 14, 6, 8, 13, 6, 5, 15, 13, 11, 11};
    }

    public RipeMD160() {
        super("ripemd160", 20, 64);
    }

    private RipeMD160(RipeMD160 md) {
        this();
        this.h0 = md.h0;
        this.h1 = md.h1;
        this.h2 = md.h2;
        this.h3 = md.h3;
        this.h4 = md.h4;
        this.count = md.count;
        this.buffer = (byte[])md.buffer.clone();
    }

    public Object clone() {
        return new RipeMD160(this);
    }

    protected void transform(byte[] in, int offset) {
        int T;
        int s;
        int Ep;
        int Dp;
        int Cp;
        int Bp;
        int Ap;
        int i = 0;
        while (i < 16) {
            this.X[i] = in[offset++] & 0xFF | (in[offset++] & 0xFF) << 8 | (in[offset++] & 0xFF) << 16 | in[offset++] << 24;
            ++i;
        }
        int A = Ap = this.h0;
        int B = Bp = this.h1;
        int C = Cp = this.h2;
        int D = Dp = this.h3;
        int E = Ep = this.h4;
        i = 0;
        while (i < 16) {
            s = S[i];
            T = A + (B ^ C ^ D) + this.X[i];
            A = E;
            E = D;
            D = C << 10 | C >>> 22;
            C = B;
            B = (T << s | T >>> 32 - s) + A;
            s = Sp[i];
            T = Ap + (Bp ^ (Cp | ~Dp)) + this.X[Rp[i]] + 1352829926;
            Ap = Ep;
            Ep = Dp;
            Dp = Cp << 10 | Cp >>> 22;
            Cp = Bp;
            Bp = (T << s | T >>> 32 - s) + Ap;
            ++i;
        }
        while (i < 32) {
            s = S[i];
            T = A + (B & C | ~B & D) + this.X[R[i]] + 1518500249;
            A = E;
            E = D;
            D = C << 10 | C >>> 22;
            C = B;
            B = (T << s | T >>> 32 - s) + A;
            s = Sp[i];
            T = Ap + (Bp & Dp | Cp & ~Dp) + this.X[Rp[i]] + 1548603684;
            Ap = Ep;
            Ep = Dp;
            Dp = Cp << 10 | Cp >>> 22;
            Cp = Bp;
            Bp = (T << s | T >>> 32 - s) + Ap;
            ++i;
        }
        while (i < 48) {
            s = S[i];
            T = A + ((B | ~C) ^ D) + this.X[R[i]] + 1859775393;
            A = E;
            E = D;
            D = C << 10 | C >>> 22;
            C = B;
            B = (T << s | T >>> 32 - s) + A;
            s = Sp[i];
            T = Ap + ((Bp | ~Cp) ^ Dp) + this.X[Rp[i]] + 1836072691;
            Ap = Ep;
            Ep = Dp;
            Dp = Cp << 10 | Cp >>> 22;
            Cp = Bp;
            Bp = (T << s | T >>> 32 - s) + Ap;
            ++i;
        }
        while (i < 64) {
            s = S[i];
            T = A + (B & D | C & ~D) + this.X[R[i]] + -1894007588;
            A = E;
            E = D;
            D = C << 10 | C >>> 22;
            C = B;
            B = (T << s | T >>> 32 - s) + A;
            s = Sp[i];
            T = Ap + (Bp & Cp | ~Bp & Dp) + this.X[Rp[i]] + 2053994217;
            Ap = Ep;
            Ep = Dp;
            Dp = Cp << 10 | Cp >>> 22;
            Cp = Bp;
            Bp = (T << s | T >>> 32 - s) + Ap;
            ++i;
        }
        while (i < 80) {
            s = S[i];
            T = A + (B ^ (C | ~D)) + this.X[R[i]] + -1454113458;
            A = E;
            E = D;
            D = C << 10 | C >>> 22;
            C = B;
            B = (T << s | T >>> 32 - s) + A;
            s = Sp[i];
            T = Ap + (Bp ^ Cp ^ Dp) + this.X[Rp[i]];
            Ap = Ep;
            Ep = Dp;
            Dp = Cp << 10 | Cp >>> 22;
            Cp = Bp;
            Bp = (T << s | T >>> 32 - s) + Ap;
            ++i;
        }
        T = this.h1 + C + Dp;
        this.h1 = this.h2 + D + Ep;
        this.h2 = this.h3 + E + Ap;
        this.h3 = this.h4 + A + Bp;
        this.h4 = this.h0 + B + Cp;
        this.h0 = T;
    }

    protected byte[] padBuffer() {
        int n = (int)(this.count % 64L);
        int padding = n < 56 ? 56 - n : 120 - n;
        byte[] result = new byte[padding + 8];
        result[0] = -128;
        long bits = this.count << 3;
        result[padding++] = (byte)bits;
        result[padding++] = (byte)(bits >>> 8);
        result[padding++] = (byte)(bits >>> 16);
        result[padding++] = (byte)(bits >>> 24);
        result[padding++] = (byte)(bits >>> 32);
        result[padding++] = (byte)(bits >>> 40);
        result[padding++] = (byte)(bits >>> 48);
        result[padding] = (byte)(bits >>> 56);
        return result;
    }

    protected byte[] getResult() {
        return new byte[]{(byte)this.h0, (byte)(this.h0 >>> 8), (byte)(this.h0 >>> 16), (byte)(this.h0 >>> 24), (byte)this.h1, (byte)(this.h1 >>> 8), (byte)(this.h1 >>> 16), (byte)(this.h1 >>> 24), (byte)this.h2, (byte)(this.h2 >>> 8), (byte)(this.h2 >>> 16), (byte)(this.h2 >>> 24), (byte)this.h3, (byte)(this.h3 >>> 8), (byte)(this.h3 >>> 16), (byte)(this.h3 >>> 24), (byte)this.h4, (byte)(this.h4 >>> 8), (byte)(this.h4 >>> 16), (byte)(this.h4 >>> 24)};
    }

    protected void resetContext() {
        this.h0 = 1732584193;
        this.h1 = -271733879;
        this.h2 = -1732584194;
        this.h3 = 271733878;
        this.h4 = -1009589776;
    }

    public boolean selfTest() {
        if (valid == null) {
            String d = Util.toString(new RipeMD160().digest());
            valid = DIGEST0.equals(d);
        }
        return valid;
    }
}

