/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GtkImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.nio.ByteOrder;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GtkImageConsumer
implements ImageConsumer {
    private GtkImage target;
    private int width;
    private int height;
    private Hashtable<?, ?> properties;
    private int[] pixelCache = null;
    private ImageProducer source;

    public GtkImageConsumer(GtkImage target, ImageProducer source) {
        this.target = target;
        this.source = source;
    }

    @Override
    public synchronized void imageComplete(int status) {
        if (!(this.source instanceof MemoryImageSource)) {
            this.source.removeConsumer(this);
        }
        this.target.setImage(this.width, this.height, this.pixelCache, this.properties);
    }

    @Override
    public synchronized void setColorModel(ColorModel model) {
    }

    @Override
    public synchronized void setDimensions(int width, int height) {
        this.pixelCache = new int[width * height];
        this.width = width;
        this.height = height;
    }

    @Override
    public synchronized void setHints(int flags) {
    }

    @Override
    public synchronized void setPixels(int x, int y, int width, int height, ColorModel cm, byte[] pixels, int offset, int scansize) {
        this.setPixels(x, y, width, height, cm, this.convertPixels(pixels), offset, scansize);
    }

    @Override
    public synchronized void setPixels(int x, int y, int width, int height, ColorModel cm, int[] pixels, int offset, int scansize) {
        if (this.pixelCache == null) {
            return;
        }
        if (cm.equals(GtkImage.nativeModel)) {
            int i = 0;
            while (i < height) {
                System.arraycopy(pixels, offset + i * scansize, this.pixelCache, (y + i) * this.width + x, width);
                ++i;
            }
        } else if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    int pix = cm.getRGB(pixels[offset + i * scansize + x + j]);
                    int a = (pix & 0xFF000000) >> 24 & 0xFF;
                    int rgb = (pix & 0xFFFFFF) << 8;
                    this.pixelCache[(y + i) * this.width + x + j] = pix = rgb | a;
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    int pix = cm.getRGB(pixels[offset + i * scansize + x + j]);
                    byte b = (byte)(pix & 0xFF);
                    byte r = (byte)((pix & 0xFF0000) >> 16 & 0xFF);
                    pix &= 0xFF00FF00;
                    pix |= (b & 0xFF) << 16;
                    this.pixelCache[(y + i) * this.width + x + j] = pix |= r & 0xFF;
                    ++j;
                }
                ++i;
            }
        }
    }

    private int[] convertPixels(byte[] pixels) {
        int[] ret = new int[pixels.length];
        int i = 0;
        while (i < pixels.length) {
            ret[i] = pixels[i] & 0xFF;
            ++i;
        }
        return ret;
    }

    @Override
    public synchronized void setProperties(Hashtable<?, ?> props) {
        this.properties = props;
    }
}

