;;;;;;;;;;;;;;;;;;;;;;;;;;;;;<--OGI-->;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                        ;;
;;             Center for Spoken Language Understanding                   ;;
;;        Oregon Graduate Institute of Science & Technology               ;;
;;                         Portland, OR USA                               ;;
;;                        Copyright (c) 2000                              ;;
;;                                                                        ;;
;;      This module is not part of the CSTR/University of Edinburgh       ;;
;;               release of the Festival TTS system.                      ;;
;;                                                                        ;;
;;  In addition to any conditions disclaimers below, please see the file  ;;
;;  "license_ogi_tts.txt" distributed with this software for information  ;;
;;  on usage and redistribution, and for a DISCLAIMER OF ALL WARRANTIES.  ;;
;;                                                                        ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;<--OGI-->;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  This file is additional code NOT INCLUDED with the Festival TTS 
;;;   system as distributed by CSTR/University of Edinburgh.  
;;;
;;;  Festival is being redistributed with permission of CSTR as part of 
;;;   the CSLU Toolkit.   
;;;
;;;  The CSLU Toolkit and this code are 
;;;    Copyright (C)1997 Center for Spoken Language Understanding,
;;;                      Oregon Graduate Institute of Science & Technology
;;;
;;; In addition to conditions disclaimers below, please see the file "license.ogi" 
;;; for information on usage and redistribution, and for a DISCLAIMER OF ALL WARRANTIES.
;;;

(define (OGI_PuncPhrasify utt)
  "(OGI_PuncPhrasify utt)
Put in preliminary phrase breaks based only on the punctuation, then call festival Phrasify function"
  (mapcar
   (lambda (w)
     (if (not (null? (item.next w)))
	 (let ((npos (item.feat (item.next w) "pos")))
	   (if (or (string-equal "punc" npos)
		   (string-equal "fpunc" npos))
	       (item.set_feat (item.parent (item.relation w "Token")) "pbreak" "B")))))
   (utt.relation.items utt "Word"))
  (festival-phrasify utt)
  utt)


(defvar OGI_english_phr_break_params
  (list
   ;; The name and filename off the ngram with the a priori ngram model
   ;; for predicting phrase breaks in the Phrasify module.  This model should 
   ;; predict probability distributions for B and NB given some context of 
   ;; part of  speech tags.
   (list 'pos_ngram_name 'english_break_pos_ngram)
   (list 'pos_ngram_filename
	 (path-append pbreak_ngram_dir "sec.ts20.quad.ngrambin"))
   ;; The name and filename of the ngram  containing the a posteriori ngram
   ;; for predicting phrase breaks in the Phrasify module.  This module should
   ;; predict probability distributions for B and NB given previous B and
   ;; NBs.
   (list 'break_ngram_name 'english_break_ngram)
   (list 'break_ngram_filename
	 (path-append pbreak_ngram_dir "sec.B.hept.ngrambin"))
   ;; A weighting factor for breaks in the break/non-break ngram.
   ;;   ** changed by MWM **
   (list 'gram_scale_s 0.25)
   ;; When Phrase_Method is prob_models, this tree, if set is used to 
   ;; potentially predict phrase type.  At least some prob_models only
   ;; predict B or NB, this tree may be used to change some Bs into
   ;; BBs.  If it is nil, the pbreak value predicted by prob_models
   ;; remains the same.
   (list 'phrase_type_tree english_phrase_type_tree)
   ;; A list of tags used in identifying breaks.  Typically B and NB (and
   ;; BB).  This should be the alphabet of the ngram identified in
   ;; break_ngram_name
   (list 'break_tags '(B NB))
   (list 'pos_map english_pos_map_wp39_to_wp20)
   ))



(provide 'ogi_phrase)
