DROP TABLE IF EXISTS `config`;
CREATE TABLE `config` ( `config_id` int(11) NOT NULL AUTO_INCREMENT, `config_name` varchar(255) NOT NULL, `config_value` varchar(512) NOT NULL, `config_default` varchar(512) NOT NULL, `config_descr` varchar(100) NOT NULL, `config_group` varchar(50) NOT NULL, `config_group_order` int(11) NOT NULL, `config_sub_group` varchar(50) NOT NULL, `config_sub_group_order` int(11) NOT NULL, `config_hidden` enum('0','1') NOT NULL DEFAULT '0', `config_disabled` enum('0','1') NOT NULL DEFAULT '0', PRIMARY KEY (`config_id`)) ENGINE=InnoDB AUTO_INCREMENT=720 DEFAULT CHARSET=latin1;
LOCK TABLES `config` WRITE;
INSERT INTO `config` VALUES (441,'alert.macros.rule.now','NOW()','NOW()','Macro currenttime','alerting',0,'macros',0,'1','0'),(442,'alert.macros.rule.past_5m','DATE_SUB(NOW(),INTERVAL 5 MINUTE)','DATE_SUB(NOW(),INTERVAL 5 MINUTE)','Macro past 5 minutes','alerting',0,'macros',0,'1','0'),(443,'alert.macros.rule.past_10m','DATE_SUB(NOW(),INTERVAL 10 MINUTE)','DATE_SUB(NOW(),INTERVAL 10 MINUTE)','Macro past 10 minutes','alerting',0,'macros',0,'1','0'),(444,'alert.macros.rule.past_15m','DATE_SUB(NOW(),INTERVAL 15 MINUTE)','DATE_SUB(NOW(),INTERVAL 15 MINUTE)','Macro past 15 minutes','alerting',0,'macros',0,'1','0'),(445,'alert.macros.rule.past_30m','DATE_SUB(NOW(),INTERVAL 30 MINUTE)','DATE_SUB(NOW(),INTERVAL 30 MINUTE)','Macro past 30 minutes','alerting',0,'macros',0,'1','0'),(446,'alert.macros.rule.device','(%devices.disabled = 0 && %devices.ignore = 0)','(%devices.disabled = 0 && %devices.ignore = 0)','Devices that aren\'t disabled or ignored','alerting',0,'macros',0,'1','0'),(447,'alert.macros.rule.device_up','(%devices.status = 1 && %macros.device)','(%devices.status = 1 && %macros.device)','Devices that are up','alerting',0,'macros',0,'1','0'),(448,'alert.macros.rule.device_down','(%devices.status = 0 && %macros.device)','(%devices.status = 0 && %macros.device)','Devices that are down','alerting',0,'macros',0,'1','0'),(449,'alert.macros.rule.port','(%ports.deleted = 0 && %ports.ignore = 0 && %ports.disabled = 0)','(%ports.deleted = 0 && %ports.ignore = 0 && %ports.disabled = 0)','Ports that aren\'t disabled, ignored or delete','alerting',0,'macros',0,'1','0'),(450,'alert.macros.rule.port_up','(%ports.ifOperStatus = \"up\" && %ports.ifAdminStatus = \"up\" && %macros.port)','(%ports.ifOperStatus = \"up\" && %ports.ifAdminStatus = \"up\" && %macros.port)','Ports that are up','alerting',0,'macros',0,'1','0'),(451,'alert.admins','true','true','Alert administrators','alerting',0,'general',0,'0','0'),(452,'alert.default_only','true','true','Only alert default mail contact','alerting',0,'general',0,'0','0'),(453,'alert.default_mail','','','The default mail contact','alerting',0,'general',0,'0','0'),(454,'alert.transports.pagerduty','','','Pagerduty transport - put your API key here','alerting',0,'transports',0,'0','0'),(455,'alert.pagerduty.account','','','Pagerduty account name','alerting',0,'transports',0,'0','0'),(456,'alert.pagerduty.service','','','Pagerduty service name','alerting',0,'transports',0,'0','0'),(457,'alert.tolerance_window','5','5','Tolerance window in seconds','alerting',0,'general',0,'0','0'),(458,'email_backend','mail','mail','The backend to use for sending email, can be mail, sendmail or smtp','alerting',0,'general',0,'0','0'),(459,'alert.macros.rule.past_60m','DATE_SUB(NOW(),INTERVAL 60 MINUTE)','DATE_SUB(NOW(),INTERVAL 60 MINUTE)','Macro past 60 minutes','alerting',0,'macros',0,'1','0'),(460,'alert.macros.rule.port_usage_perc','((%ports.ifInOctets_rate*8)/%ports.ifSpeed)*100','((%ports.ifInOctets_rate*8)/%ports.ifSpeed)*100','Ports using more than X perc','alerting',0,'macros',0,'1','0'),(461,'alert.transports.dummy','false','false','Dummy transport','alerting',0,'transports',0,'0','0'),(462,'alert.transports.mail','true','true','Mail alerting transport','alerting',0,'transports',0,'0','0'),(463,'alert.transports.irc','FALSE','false','IRC alerting transport','alerting',0,'transports',0,'0','0'),(464,'alert.globals','true','TRUE','Alert read only administrators','alerting',0,'general',0,'0','0'),(465,'email_from','NULL','NULL','Email address used for sending emails (from)','alerting',0,'general',0,'0','0'),(466,'email_user','LibreNMS','LibreNMS','Name used as part of the from address','alerting',0,'general',0,'0','0'),(467,'email_sendmail_path','/usr/sbin/sendmail','/usr/sbin/sendmail','Location of sendmail if using this option','alerting',0,'general',0,'0','0'),(468,'email_smtp_host','localhost','localhost','SMTP Host for sending email if using this option','alerting',0,'general',0,'0','0'),(469,'email_smtp_port','25','25','SMTP port setting','alerting',0,'general',0,'0','0'),(470,'email_smtp_timeout','10','10','SMTP timeout setting','alerting',0,'general',0,'0','0'),(471,'email_smtp_secure','','','Enable / disable encryption (use tls or ssl)','alerting',0,'general',0,'0','0'),(472,'email_smtp_auth','false','FALSE','Enable / disable smtp authentication','alerting',0,'general',0,'0','0'),(473,'email_smtp_username','NULL','NULL','SMTP Auth username','alerting',0,'general',0,'0','0'),(474,'email_smtp_password','NULL','NULL','SMTP Auth password','alerting',0,'general',0,'0','0'),(475,'alert.macros.rule.port_down','(%ports.ifOperStatus = \"down\" && %ports.ifAdminStatus != \"down\" && %macros.port)','(%ports.ifOperStatus = \"down\" && %ports.ifAdminStatus != \"down\" && %macros.port)','Ports that are down','alerting',0,'macros',0,'1','0'),(486,'alert.syscontact','true','TRUE','Issue alerts to sysContact','alerting',0,'general',0,'0','0'),(487,'alert.fixed-contacts','true','TRUE','If TRUE any changes to sysContact or users emails will not be honoured whilst alert is active','alerting',0,'general',0,'0','0'),(488,'alert.transports.nagios','','','Nagios compatible via FIFO','alerting',0,'transports',0,'0','0');
UNLOCK TABLES;
