/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.config;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import org.w3c.dom.Node;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class Param<T>
implements Serializable {
    private static final JAXBContext JAXB_CTX;
    private static final Marshaller MARSHALLER;
    private static final Unmarshaller UNMARSHALLER;
    private static final Map<Class<?>, String> map;
    private static final Map<String, Class<?>> reverseMap;
    @XmlTransient
    private Class<T> type;
    @XmlAttribute(name="name")
    private String name;
    @XmlValue
    private String value;
    @XmlTransient
    private T actualValue;

    public Param() {
    }

    public Param(String name, Class<T> type, T value) {
        this.name = name;
        this.type = type;
        this.value = value.toString();
    }

    public Param(String name, T value) {
        this(name, value.getClass(), value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlTransient
    public Class<T> getType() {
        return this.type;
    }

    public void setType(Class<T> type) {
        this.type = type;
    }

    @XmlAttribute(name="type")
    public String getTypeString() {
        if (this.type == null) {
            return null;
        }
        if (map.containsKey(this.type)) {
            return map.get(this.type);
        }
        return this.type.getName();
    }

    public void setTypeString(String type) {
        if (type == null || type.isEmpty()) {
            return;
        }
        if (reverseMap.containsKey(type)) {
            this.type = reverseMap.get(type);
        } else {
            try {
                this.type = Class.forName(type);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        this.actualValue = null;
    }

    @XmlTransient
    public T getValue() {
        if (this.actualValue == null) {
            try {
                Constructor<T> constructor = this.type.getConstructor(String.class);
                constructor.setAccessible(true);
                this.actualValue = constructor.newInstance(this.value);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(this.type + " doesnt have a constructor that takes String arg", e);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return this.actualValue;
    }

    public String toString() {
        return "Param{name='" + this.name + '\'' + ", value='" + this.value + '\'' + ", actualValue=" + this.actualValue + '}';
    }

    public void save(OutputStream stream) throws JAXBException {
        MARSHALLER.marshal((Object)this, stream);
    }

    public void save(Node node) throws JAXBException {
        MARSHALLER.marshal((Object)this, node);
    }

    public static <T> Param<T> load(InputStream stream) throws JAXBException {
        return (Param)UNMARSHALLER.unmarshal(stream);
    }

    public static <T> Param<T> load(Node node) throws JAXBException {
        return (Param)UNMARSHALLER.unmarshal(node);
    }

    static {
        map = new HashMap();
        reverseMap = new HashMap();
        map.put(Boolean.class, "bool");
        map.put(String.class, "string");
        map.put(Byte.class, "byte");
        map.put(Short.class, "short");
        map.put(Integer.class, "int");
        map.put(Long.class, "long");
        map.put(BigInteger.class, "bigint");
        map.put(Float.class, "float");
        map.put(Double.class, "double");
        map.put(File.class, "file");
        map.put(URI.class, "uri");
        map.put(URL.class, "url");
        for (Map.Entry<Class<?>, String> entry : map.entrySet()) {
            reverseMap.put(entry.getValue(), entry.getKey());
        }
        try {
            JAXB_CTX = JAXBContext.newInstance((Class[])new Class[]{Param.class});
            MARSHALLER = JAXB_CTX.createMarshaller();
            MARSHALLER.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            UNMARSHALLER = JAXB_CTX.createUnmarshaller();
            UNMARSHALLER.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

