/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.SolrCmdDistributor;
import org.apache.solr.update.processor.DistributedUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeRoutedAliasUpdateProcessor
extends UpdateRequestProcessor {
    public static final String ALIAS_DISTRIB_UPDATE_PARAM = "alias.update.distrib";
    public static final String TIME_PARTITION_ALIAS_NAME_CORE_PROP = "timePartitionAliasName";
    public static final String ROUTER_FIELD_METADATA = "router.field";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendPattern("[_HH[_mm[_ss]]]").parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter(Locale.ROOT).withZone(ZoneOffset.UTC);
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String thisCollection;
    private final String aliasName;
    private final String routeField;
    private final SolrCmdDistributor cmdDistrib;
    private final ZkController zkController;
    private final SolrParams outParamsToLeader;
    private List<Map.Entry<Instant, String>> parsedCollectionsDesc;
    private Aliases parsedCollectionsAliases;

    public static UpdateRequestProcessor wrap(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        String timePartitionAliasName = req.getCore().getCoreDescriptor().getCoreProperty(TIME_PARTITION_ALIAS_NAME_CORE_PROP, null);
        DistributedUpdateProcessor.DistribPhase shardDistribPhase = DistributedUpdateProcessor.DistribPhase.parseParam(req.getParams().get("update.distrib"));
        DistributedUpdateProcessor.DistribPhase aliasDistribPhase = DistributedUpdateProcessor.DistribPhase.parseParam(req.getParams().get(ALIAS_DISTRIB_UPDATE_PARAM));
        if (timePartitionAliasName == null || aliasDistribPhase != DistributedUpdateProcessor.DistribPhase.NONE || shardDistribPhase != DistributedUpdateProcessor.DistribPhase.NONE) {
            return next;
        }
        return new TimeRoutedAliasUpdateProcessor(req, rsp, next, timePartitionAliasName, aliasDistribPhase);
    }

    protected TimeRoutedAliasUpdateProcessor(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next, String aliasName, DistributedUpdateProcessor.DistribPhase aliasDistribPhase) {
        super(next);
        assert (aliasDistribPhase == DistributedUpdateProcessor.DistribPhase.NONE);
        SolrCore core = req.getCore();
        this.thisCollection = core.getCoreDescriptor().getCloudDescriptor().getCollectionName();
        this.aliasName = aliasName;
        CoreContainer cc = core.getCoreContainer();
        this.zkController = cc.getZkController();
        this.cmdDistrib = new SolrCmdDistributor(cc.getUpdateShardHandler());
        Map aliasMetadata = this.zkController.getZkStateReader().getAliases().getCollectionAliasMetadata(aliasName);
        if (aliasMetadata == null) {
            throw this.newAliasMustExistException();
        }
        this.routeField = (String)aliasMetadata.get(ROUTER_FIELD_METADATA);
        ModifiableSolrParams outParams = new ModifiableSolrParams(req.getParams());
        outParams.remove("optimize");
        outParams.remove("commit");
        outParams.remove("softCommit");
        outParams.remove("prepareCommit");
        outParams.remove("rollback");
        outParams.set("update.distrib", new String[]{DistributedUpdateProcessor.DistribPhase.NONE.toString()});
        outParams.set(ALIAS_DISTRIB_UPDATE_PARAM, new String[]{DistributedUpdateProcessor.DistribPhase.TOLEADER.toString()});
        outParams.set("distrib.from", new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)core.getName())});
        this.outParamsToLeader = outParams;
    }

    @Override
    public void processAdd(AddUpdateCommand cmd) throws IOException {
        Object routeValue = cmd.getSolrInputDocument().getFieldValue(this.routeField);
        String targetCollection = this.findTargetCollectionGivenRouteKey(routeValue);
        if (targetCollection == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Doc " + cmd.getPrintableId() + " couldn't be routed with " + this.routeField + "=" + routeValue);
        }
        if (this.thisCollection.equals(targetCollection)) {
            super.processAdd(cmd);
        } else {
            SolrCmdDistributor.Node targetLeaderNode = this.lookupShardLeaderOfCollection(targetCollection);
            this.cmdDistrib.distribAdd(cmd, Collections.singletonList(targetLeaderNode), new ModifiableSolrParams(this.outParamsToLeader));
        }
    }

    protected String findTargetCollectionGivenRouteKey(Object routeKey) {
        Instant docTimestamp;
        if (routeKey instanceof Instant) {
            docTimestamp = (Instant)routeKey;
        } else if (routeKey instanceof Date) {
            docTimestamp = ((Date)routeKey).toInstant();
        } else if (routeKey instanceof CharSequence) {
            docTimestamp = Instant.parse((CharSequence)routeKey);
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unexpected type of routeKey: " + routeKey);
        }
        Aliases aliases = this.zkController.getZkStateReader().getAliases();
        if (this.parsedCollectionsAliases != aliases) {
            if (this.parsedCollectionsAliases != null) {
                log.info("Observing possibly updated alias {}", (Object)this.aliasName);
            }
            this.parsedCollectionsDesc = this.doParseCollections(aliases);
            this.parsedCollectionsAliases = aliases;
        }
        for (Map.Entry<Instant, String> entry : this.parsedCollectionsDesc) {
            Instant colStartTime = entry.getKey();
            if (docTimestamp.isBefore(colStartTime)) continue;
            return entry.getValue();
        }
        return null;
    }

    private List<Map.Entry<Instant, String>> doParseCollections(Aliases aliases) {
        List collections = (List)aliases.getCollectionAliasListMap().get(this.aliasName);
        if (collections == null) {
            throw this.newAliasMustExistException();
        }
        ArrayList<Map.Entry<Instant, String>> result = new ArrayList<Map.Entry<Instant, String>>(collections.size());
        for (String collection : collections) {
            Instant colStartTime = TimeRoutedAliasUpdateProcessor.parseInstantFromCollectionName(this.aliasName, collection);
            result.add(new AbstractMap.SimpleImmutableEntry<Instant, String>(colStartTime, collection));
        }
        result.sort((e1, e2) -> ((Instant)e2.getKey()).compareTo((Instant)e1.getKey()));
        return result;
    }

    private SolrException newAliasMustExistException() {
        throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Collection " + this.thisCollection + " created for use with alias " + this.aliasName + " which doesn't exist anymore. You cannot write to this unless the alias exists.");
    }

    static Instant parseInstantFromCollectionName(String aliasName, String collection) {
        String dateTimePart = collection.substring(aliasName.length() + 1);
        return DATE_TIME_FORMATTER.parse((CharSequence)dateTimePart, Instant::from);
    }

    @Override
    public void processDelete(DeleteUpdateCommand cmd) throws IOException {
        List<SolrCmdDistributor.Node> nodes = this.lookupShardLeadersOfCollections();
        this.cmdDistrib.distribDelete(cmd, nodes, new ModifiableSolrParams(this.outParamsToLeader));
    }

    @Override
    public void processCommit(CommitUpdateCommand cmd) throws IOException {
        List<SolrCmdDistributor.Node> nodes = this.lookupShardLeadersOfCollections();
        this.cmdDistrib.distribCommit(cmd, nodes, new ModifiableSolrParams(this.outParamsToLeader));
        this.cmdDistrib.blockAndDoRetries();
    }

    @Override
    public void finish() throws IOException {
        try {
            this.cmdDistrib.finish();
            List<SolrCmdDistributor.Error> errors = this.cmdDistrib.getErrors();
            if (!errors.isEmpty()) {
                throw new DistributedUpdateProcessor.DistributedUpdatesAsyncException(errors);
            }
        }
        finally {
            super.finish();
        }
    }

    @Override
    protected void doClose() {
        try {
            this.cmdDistrib.close();
        }
        finally {
            super.doClose();
        }
    }

    private List<SolrCmdDistributor.Node> lookupShardLeadersOfCollections() {
        Aliases aliases = this.zkController.getZkStateReader().getAliases();
        List collections = (List)aliases.getCollectionAliasListMap().get(this.aliasName);
        if (collections == null) {
            throw this.newAliasMustExistException();
        }
        return collections.stream().map(this::lookupShardLeaderOfCollection).collect(Collectors.toList());
    }

    private SolrCmdDistributor.Node lookupShardLeaderOfCollection(String collection) {
        Collection activeSlices = this.zkController.getClusterState().getCollection(collection).getActiveSlices();
        if (activeSlices.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Cannot route to collection " + collection);
        }
        Slice slice = (Slice)activeSlices.iterator().next();
        Replica leader = slice.getLeader();
        if (leader == null) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "No 'leader' replica available for shard " + slice.getName() + " of collection " + collection);
        }
        return new SolrCmdDistributor.RetryNode(new ZkCoreNodeProps((ZkNodeProps)leader), this.zkController.getZkStateReader(), collection, null);
    }
}

