/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import org.apache.solr.cloud.ElectionContext;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OverseerElectionContext
extends ElectionContext {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SolrZkClient zkClient;
    private Overseer overseer;

    public OverseerElectionContext(SolrZkClient zkClient, Overseer overseer, String zkNodeName) {
        super(zkNodeName, "/overseer_elect", "/overseer_elect/leader", null, zkClient);
        this.overseer = overseer;
        this.zkClient = zkClient;
        try {
            new ZkCmdExecutor(zkClient.getZkClientTimeout()).ensureExists("/overseer_elect", zkClient);
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    @Override
    void runLeaderProcess(boolean weAreReplacement, int pauseBeforeStartMs) throws KeeperException, InterruptedException {
        log.info("I am going to be the leader {}", (Object)this.id);
        String id = this.leaderSeqPath.substring(this.leaderSeqPath.lastIndexOf("/") + 1);
        ZkNodeProps myProps = new ZkNodeProps(new String[]{"id", id});
        this.zkClient.makePath(this.leaderPath, Utils.toJSON((Object)myProps), CreateMode.EPHEMERAL, true);
        if (pauseBeforeStartMs > 0) {
            try {
                Thread.sleep(pauseBeforeStartMs);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                log.warn("Wait interrupted ", (Throwable)e);
            }
        }
        if (this.overseer.getZkController() == null || this.overseer.getZkController().getCoreContainer() == null || !this.overseer.getZkController().getCoreContainer().isShutDown()) {
            this.overseer.start(id);
        }
    }

    @Override
    public void cancelElection() throws InterruptedException, KeeperException {
        super.cancelElection();
        this.overseer.close();
    }

    @Override
    public void close() {
        this.overseer.close();
    }

    @Override
    public ElectionContext copy() {
        return new OverseerElectionContext(this.zkClient, this.overseer, this.id);
    }

    @Override
    public void joinedElectionFired() {
        this.overseer.close();
    }

    @Override
    public void checkIfIamLeaderFired() {
        this.overseer.close();
    }
}

