/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.uima.processor;

import org.apache.lucene.analysis.uima.ae.AEProvider;
import org.apache.lucene.analysis.uima.ae.AEProviderFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.uima.processor.SolrUIMAConfiguration;
import org.apache.solr.uima.processor.SolrUIMAConfigurationReader;
import org.apache.solr.uima.processor.UIMAUpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.JCasPool;

public class UIMAUpdateRequestProcessorFactory
extends UpdateRequestProcessorFactory {
    private NamedList<Object> args;
    private AnalysisEngine ae;
    private JCasPool pool;

    public void init(NamedList args) {
        this.args = (NamedList)args.get("uimaConfig");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        SolrUIMAConfiguration configuration = new SolrUIMAConfigurationReader(this.args).readSolrUIMAConfiguration();
        UIMAUpdateRequestProcessorFactory uIMAUpdateRequestProcessorFactory = this;
        synchronized (uIMAUpdateRequestProcessorFactory) {
            if (this.ae == null && this.pool == null) {
                AEProvider aeProvider = AEProviderFactory.getInstance().getAEProvider(req.getCore().getName(), configuration.getAePath(), configuration.getRuntimeParameters());
                try {
                    this.ae = aeProvider.getAE();
                    this.pool = new JCasPool(10, this.ae);
                }
                catch (ResourceInitializationException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
                }
            }
        }
        return new UIMAUpdateRequestProcessor(next, req.getCore().getName(), configuration, this.ae, this.pool);
    }
}

