/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.stats;

import org.apache.lucene.search.CollectionStatistics;
import org.apache.solr.search.stats.StatsUtil;

public class CollectionStats {
    public final String field;
    public long maxDoc;
    public long docCount;
    public long sumTotalTermFreq;
    public long sumDocFreq;

    public CollectionStats(String field) {
        this.field = field;
    }

    public CollectionStats(String field, long maxDoc, long docCount, long sumTotalTermFreq, long sumDocFreq) {
        this.field = field;
        this.maxDoc = maxDoc;
        this.docCount = docCount;
        this.sumTotalTermFreq = sumTotalTermFreq;
        this.sumDocFreq = sumDocFreq;
    }

    public CollectionStats(CollectionStatistics stats) {
        this.field = stats.field();
        this.maxDoc = stats.maxDoc();
        this.docCount = stats.docCount();
        this.sumTotalTermFreq = stats.sumTotalTermFreq();
        this.sumDocFreq = stats.sumDocFreq();
    }

    public void add(CollectionStats stats) {
        this.maxDoc += stats.maxDoc;
        this.docCount = this.docCount < 0L || stats.docCount < 0L ? -1L : (this.docCount += stats.docCount);
        this.sumTotalTermFreq = this.sumTotalTermFreq < 0L || stats.sumTotalTermFreq < 0L ? -1L : (this.sumTotalTermFreq += stats.sumTotalTermFreq);
        this.sumDocFreq = this.sumDocFreq < 0L || stats.sumDocFreq < 0L ? -1L : (this.sumDocFreq += stats.sumDocFreq);
    }

    public CollectionStatistics toCollectionStatistics() {
        return new CollectionStatistics(this.field, this.maxDoc, this.docCount, this.sumTotalTermFreq, this.sumDocFreq);
    }

    public String toString() {
        return StatsUtil.colStatsToString(this);
    }
}

