/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Rescorer;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.handler.component.MergeStrategy;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.search.QueryCommand;
import org.apache.solr.search.RankQuery;
import org.apache.solr.search.ReRankCollector;
import org.apache.solr.search.ReRankWeight;

public abstract class AbstractReRankQuery
extends RankQuery {
    protected Query mainQuery;
    protected final int reRankDocs;
    protected final Rescorer reRankQueryRescorer;
    protected Map<BytesRef, Integer> boostedPriority;

    public AbstractReRankQuery(Query mainQuery, int reRankDocs, Rescorer reRankQueryRescorer) {
        this.mainQuery = mainQuery;
        this.reRankDocs = reRankDocs;
        this.reRankQueryRescorer = reRankQueryRescorer;
    }

    @Override
    public RankQuery wrap(Query _mainQuery) {
        if (_mainQuery != null) {
            this.mainQuery = _mainQuery;
        }
        return this;
    }

    @Override
    public MergeStrategy getMergeStrategy() {
        return null;
    }

    @Override
    public TopDocsCollector getTopDocsCollector(int len, QueryCommand cmd, IndexSearcher searcher) throws IOException {
        SolrRequestInfo info;
        if (this.boostedPriority == null && (info = SolrRequestInfo.getRequestInfo()) != null) {
            Map<Object, Object> context = info.getReq().getContext();
            this.boostedPriority = (Map)context.get("BOOSTED_PRIORITY");
        }
        return new ReRankCollector(this.reRankDocs, len, this.reRankQueryRescorer, cmd, searcher, this.boostedPriority);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query q = this.mainQuery.rewrite(reader);
        if (q != this.mainQuery) {
            return this.rewrite(q);
        }
        return super.rewrite(reader);
    }

    protected abstract Query rewrite(Query var1) throws IOException;

    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        Weight mainWeight = this.mainQuery.createWeight(searcher, needsScores, boost);
        return new ReRankWeight(this.mainQuery, this.reRankQueryRescorer, searcher, mainWeight);
    }
}

