/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Registry;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.URLUtil;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.component.HttpShardHandler;
import org.apache.solr.handler.component.ReplicaListTransformer;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.handler.component.ShufflingReplicaListTransformer;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.apache.solr.util.stats.HttpClientMetricNameStrategy;
import org.apache.solr.util.stats.InstrumentedHttpRequestExecutor;
import org.apache.solr.util.stats.InstrumentedPoolingHttpClientConnectionManager;
import org.apache.solr.util.stats.MetricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpShardHandlerFactory
extends ShardHandlerFactory
implements PluginInfoInitialized,
SolrMetricProducer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String DEFAULT_SCHEME = "http";
    private ExecutorService commExecutor = new ExecutorUtil.MDCAwareThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue(), (ThreadFactory)new DefaultSolrThreadFactory("httpShardExecutor"));
    protected InstrumentedPoolingHttpClientConnectionManager clientConnectionManager;
    protected CloseableHttpClient defaultClient;
    protected InstrumentedHttpRequestExecutor httpRequestExecutor;
    private LBHttpSolrClient loadbalancer;
    int soTimeout = 600000;
    int connectionTimeout = 60000;
    int maxConnectionsPerHost = 20;
    int maxConnections = 10000;
    int corePoolSize = 0;
    int maximumPoolSize = Integer.MAX_VALUE;
    int keepAliveTime = 5;
    int queueSize = -1;
    int permittedLoadBalancerRequestsMinimumAbsolute = 0;
    float permittedLoadBalancerRequestsMaximumFraction = 1.0f;
    boolean accessPolicy = false;
    private String scheme = null;
    private HttpClientMetricNameStrategy metricNameStrategy;
    protected final Random r = new Random();
    private final ReplicaListTransformer shufflingReplicaListTransformer = new ShufflingReplicaListTransformer(this.r);
    static final String INIT_URL_SCHEME = "urlScheme";
    static final String INIT_CORE_POOL_SIZE = "corePoolSize";
    static final String INIT_MAX_POOL_SIZE = "maximumPoolSize";
    static final String MAX_THREAD_IDLE_TIME = "maxThreadIdleTime";
    static final String INIT_SIZE_OF_QUEUE = "sizeOfQueue";
    static final String LOAD_BALANCER_REQUESTS_MIN_ABSOLUTE = "loadBalancerRequestsMinimumAbsolute";
    static final String LOAD_BALANCER_REQUESTS_MAX_FRACTION = "loadBalancerRequestsMaximumFraction";
    static final String INIT_FAIRNESS_POLICY = "fairnessPolicy";

    @Override
    public ShardHandler getShardHandler() {
        return this.getShardHandler((HttpClient)this.defaultClient);
    }

    public ShardHandler getShardHandler(HttpClient httpClient) {
        return new HttpShardHandler(this, httpClient);
    }

    @Override
    public void init(PluginInfo info) {
        StringBuilder sb = new StringBuilder();
        NamedList args = info.initArgs;
        this.soTimeout = this.getParameter(args, "socketTimeout", this.soTimeout, sb);
        this.scheme = this.getParameter(args, INIT_URL_SCHEME, null, sb);
        if (StringUtils.endsWith((String)this.scheme, (String)"://")) {
            this.scheme = StringUtils.removeEnd((String)this.scheme, (String)"://");
        }
        String strategy = this.getParameter(args, "metricNameStrategy", "queryLessURLAndMethod", sb);
        this.metricNameStrategy = InstrumentedHttpRequestExecutor.KNOWN_METRIC_NAME_STRATEGIES.get(strategy);
        if (this.metricNameStrategy == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown metricNameStrategy: " + strategy + " found. Must be one of: " + InstrumentedHttpRequestExecutor.KNOWN_METRIC_NAME_STRATEGIES.keySet());
        }
        this.connectionTimeout = this.getParameter(args, "connTimeout", this.connectionTimeout, sb);
        this.maxConnectionsPerHost = this.getParameter(args, "maxConnectionsPerHost", this.maxConnectionsPerHost, sb);
        this.maxConnections = this.getParameter(args, "maxConnections", this.maxConnections, sb);
        this.corePoolSize = this.getParameter(args, INIT_CORE_POOL_SIZE, this.corePoolSize, sb);
        this.maximumPoolSize = this.getParameter(args, INIT_MAX_POOL_SIZE, this.maximumPoolSize, sb);
        this.keepAliveTime = this.getParameter(args, MAX_THREAD_IDLE_TIME, this.keepAliveTime, sb);
        this.queueSize = this.getParameter(args, INIT_SIZE_OF_QUEUE, this.queueSize, sb);
        this.permittedLoadBalancerRequestsMinimumAbsolute = this.getParameter(args, LOAD_BALANCER_REQUESTS_MIN_ABSOLUTE, this.permittedLoadBalancerRequestsMinimumAbsolute, sb);
        this.permittedLoadBalancerRequestsMaximumFraction = this.getParameter(args, LOAD_BALANCER_REQUESTS_MAX_FRACTION, Float.valueOf(this.permittedLoadBalancerRequestsMaximumFraction), sb).floatValue();
        this.accessPolicy = this.getParameter(args, INIT_FAIRNESS_POLICY, this.accessPolicy, sb);
        log.debug("created with {}", (Object)sb);
        String v = System.getProperty("tests.shardhandler.randomSeed");
        if (v != null) {
            this.r.setSeed(Long.parseLong(v));
        }
        AbstractQueue blockingQueue = this.queueSize == -1 ? new SynchronousQueue(this.accessPolicy) : new ArrayBlockingQueue(this.queueSize, this.accessPolicy);
        this.commExecutor = new ExecutorUtil.MDCAwareThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, (long)this.keepAliveTime, TimeUnit.SECONDS, blockingQueue, (ThreadFactory)new DefaultSolrThreadFactory("httpShardExecutor"));
        ModifiableSolrParams clientParams = this.getClientParams();
        this.httpRequestExecutor = new InstrumentedHttpRequestExecutor(this.metricNameStrategy);
        this.clientConnectionManager = new InstrumentedPoolingHttpClientConnectionManager((Registry<ConnectionSocketFactory>)HttpClientUtil.getSchemaRegisteryProvider().getSchemaRegistry());
        this.defaultClient = HttpClientUtil.createClient((SolrParams)clientParams, (PoolingHttpClientConnectionManager)this.clientConnectionManager, (boolean)false, (HttpRequestExecutor)this.httpRequestExecutor);
        this.loadbalancer = this.createLoadbalancer((HttpClient)this.defaultClient);
    }

    protected ModifiableSolrParams getClientParams() {
        ModifiableSolrParams clientParams = new ModifiableSolrParams();
        clientParams.set("maxConnectionsPerHost", this.maxConnectionsPerHost);
        clientParams.set("maxConnections", this.maxConnections);
        return clientParams;
    }

    protected ExecutorService getThreadPoolExecutor() {
        return this.commExecutor;
    }

    protected LBHttpSolrClient createLoadbalancer(HttpClient httpClient) {
        LBHttpSolrClient client = ((LBHttpSolrClient.Builder)((LBHttpSolrClient.Builder)((LBHttpSolrClient.Builder)new LBHttpSolrClient.Builder().withHttpClient(httpClient)).withConnectionTimeout(this.connectionTimeout)).withSocketTimeout(this.soTimeout)).build();
        return client;
    }

    protected <T> T getParameter(NamedList initArgs, String configKey, T defaultValue, StringBuilder sb) {
        Object toReturn = defaultValue;
        if (initArgs != null) {
            Object temp = initArgs.get(configKey);
            T t = toReturn = temp != null ? temp : defaultValue;
        }
        if (sb != null && toReturn != null) {
            sb.append(configKey).append(" : ").append(toReturn).append(",");
        }
        return toReturn;
    }

    @Override
    public void close() {
        try {
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.commExecutor);
        }
        finally {
            try {
                if (this.loadbalancer != null) {
                    this.loadbalancer.close();
                }
            }
            finally {
                if (this.defaultClient != null) {
                    HttpClientUtil.close((HttpClient)this.defaultClient);
                }
                if (this.clientConnectionManager != null) {
                    this.clientConnectionManager.close();
                }
            }
        }
    }

    public LBHttpSolrClient.Rsp makeLoadBalancedRequest(QueryRequest req, List<String> urls) throws SolrServerException, IOException {
        return this.loadbalancer.request(this.newLBHttpSolrClientReq(req, urls));
    }

    protected LBHttpSolrClient.Req newLBHttpSolrClientReq(QueryRequest req, List<String> urls) {
        int numServersToTry = (int)Math.floor((float)urls.size() * this.permittedLoadBalancerRequestsMaximumFraction);
        if (numServersToTry < this.permittedLoadBalancerRequestsMinimumAbsolute) {
            numServersToTry = this.permittedLoadBalancerRequestsMinimumAbsolute;
        }
        return new LBHttpSolrClient.Req((SolrRequest)req, urls, Integer.valueOf(numServersToTry));
    }

    public List<String> buildURLList(String shard) {
        List urls = StrUtils.splitSmart((String)shard, (String)"|", (boolean)true);
        for (int i = 0; i < urls.size(); ++i) {
            urls.set(i, this.buildUrl((String)urls.get(i)));
        }
        return urls;
    }

    protected ReplicaListTransformer getReplicaListTransformer(SolrQueryRequest req) {
        SolrParams params = req.getParams();
        if (params.getBool("preferLocalShards", false)) {
            String preferredHostAddress;
            CoreDescriptor coreDescriptor = req.getCore().getCoreDescriptor();
            ZkController zkController = req.getCore().getCoreContainer().getZkController();
            String string = preferredHostAddress = zkController != null ? zkController.getBaseUrl() : null;
            if (preferredHostAddress == null) {
                log.warn("Couldn't determine current host address to prefer local shards");
            } else {
                return new ShufflingReplicaListTransformer(this.r){

                    @Override
                    public void transform(List<?> choices) {
                        if (choices.size() > 1) {
                            super.transform(choices);
                            if (log.isDebugEnabled()) {
                                log.debug("Trying to prefer local shard on {} among the choices: {}", (Object)preferredHostAddress, (Object)Arrays.toString(choices.toArray()));
                            }
                            choices.sort(new IsOnPreferredHostComparator(preferredHostAddress));
                            if (log.isDebugEnabled()) {
                                log.debug("Applied local shard preference for choices: {}", (Object)Arrays.toString(choices.toArray()));
                            }
                        }
                    }
                };
            }
        }
        return this.shufflingReplicaListTransformer;
    }

    public CompletionService newCompletionService() {
        return new ExecutorCompletionService(this.commExecutor);
    }

    private String buildUrl(String url) {
        if (!URLUtil.hasScheme((String)url)) {
            return StringUtils.defaultIfEmpty((String)this.scheme, (String)DEFAULT_SCHEME) + "://" + url;
        }
        if (StringUtils.isNotEmpty((String)this.scheme)) {
            return this.scheme + "://" + URLUtil.removeScheme((String)url);
        }
        return url;
    }

    @Override
    public void initializeMetrics(SolrMetricManager manager, String registry, String scope) {
        String expandedScope = SolrMetricManager.mkName(scope, SolrInfoBean.Category.QUERY.name());
        this.clientConnectionManager.initializeMetrics(manager, registry, expandedScope);
        this.httpRequestExecutor.initializeMetrics(manager, registry, expandedScope);
        this.commExecutor = MetricUtils.instrumentedExecutorService(this.commExecutor, null, manager.registry(registry), SolrMetricManager.mkName("httpShardExecutor", expandedScope, "threadPool"));
    }

    private static class IsOnPreferredHostComparator
    implements Comparator<Object> {
        private final String preferredHostAddress;

        public IsOnPreferredHostComparator(String preferredHostAddress) {
            this.preferredHostAddress = preferredHostAddress;
        }

        @Override
        public int compare(Object left, Object right) {
            boolean rhs;
            boolean lhs = this.hasPrefix(this.objectToString(left));
            if (lhs != (rhs = this.hasPrefix(this.objectToString(right)))) {
                if (lhs) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }

        private String objectToString(Object o) {
            String s = o instanceof String ? (String)o : (o instanceof Replica ? ((Replica)o).getCoreUrl() : null);
            return s;
        }

        private boolean hasPrefix(String s) {
            return s != null && s.startsWith(this.preferredHostAddress);
        }
    }
}

