/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.PolicyHelper;
import org.apache.solr.client.solrj.cloud.autoscaling.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.client.solrj.request.V2Request;
import org.apache.solr.cloud.OverseerCollectionMessageHandler;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtilizeNodeCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public UtilizeNodeCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        this.ocmh.checkRequired(message, "node");
        String nodeName = message.getStr("node");
        String async = message.getStr("async");
        AutoScalingConfig autoScalingConfig = this.ocmh.overseer.getSolrCloudManager().getDistribStateManager().getAutoScalingConfig();
        ArrayList<ZkNodeProps> requests = new ArrayList<ZkNodeProps>();
        List suggestions = PolicyHelper.getSuggestions((AutoScalingConfig)autoScalingConfig, (SolrCloudManager)this.ocmh.overseer.getSolrCloudManager());
        for (Suggester.SuggestionInfo suggestionInfo : suggestions) {
            String targetNode;
            log.info("op: " + suggestionInfo.getOperation());
            String coll = null;
            List pieces = StrUtils.splitSmart((String)suggestionInfo.getOperation().getPath(), (char)'/');
            if (pieces.size() <= 1) continue;
            coll = (String)pieces.get(2);
            log.info("coll: " + coll);
            state.getCollection(coll).forEachReplica((s, r) -> {
                if (Objects.equals(r.getName(), r.getName())) {
                    log.info("replica to be moved " + r);
                }
            });
            if (!(suggestionInfo.getOperation() instanceof V2Request) || !Objects.equals(targetNode = (String)Utils.getObjectByPath((Object)suggestionInfo.getOperation(), (boolean)true, (String)"command/move-replica/targetNode"), nodeName)) continue;
            String replica = (String)Utils.getObjectByPath((Object)suggestionInfo.getOperation(), (boolean)true, (String)"command/move-replica/replica");
            requests.add(new ZkNodeProps(new String[]{"collection", coll, "targetNode", targetNode, "async", async, "replica", replica}));
        }
        this.executeAll(requests);
        Policy.Session session = autoScalingConfig.getPolicy().createSession(this.ocmh.overseer.getSolrCloudManager());
        while (true) {
            Suggester suggester = session.getSuggester(CollectionParams.CollectionAction.MOVEREPLICA).hint(Suggester.Hint.TARGET_NODE, (Object)nodeName);
            session = suggester.getSession();
            SolrRequest request = suggester.getSuggestion();
            if (request == null) break;
            requests.add(new ZkNodeProps(new String[]{"collection", request.getParams().get("collection"), "targetNode", request.getParams().get("targetNode"), "replica", request.getParams().get("replica"), "async", request.getParams().get("async")}));
        }
        this.executeAll(requests);
    }

    private void executeAll(List<ZkNodeProps> requests) throws Exception {
        if (requests.isEmpty()) {
            return;
        }
        for (ZkNodeProps props : requests) {
            NamedList result = new NamedList();
            this.ocmh.commandMap.get(CollectionParams.CollectionAction.MOVEREPLICA).call(this.ocmh.overseer.getSolrCloudManager().getClusterStateProvider().getClusterState(), props, result);
        }
        requests.clear();
    }
}

