/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractDoubleCollection;
import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.DoubleBufferVisualizer;
import com.carrotsearch.hppc.DoubleContainer;
import com.carrotsearch.hppc.DoubleIntAssociativeContainer;
import com.carrotsearch.hppc.DoubleIntMap;
import com.carrotsearch.hppc.DoubleLookupContainer;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.IntCollection;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.DoubleCursor;
import com.carrotsearch.hppc.cursors.DoubleIntCursor;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.predicates.DoubleIntPredicate;
import com.carrotsearch.hppc.predicates.DoublePredicate;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.procedures.DoubleIntProcedure;
import com.carrotsearch.hppc.procedures.DoubleProcedure;
import com.carrotsearch.hppc.procedures.IntProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class DoubleIntHashMap
implements DoubleIntMap,
Preallocable,
Cloneable {
    public double[] keys;
    public int[] values;
    protected int keyMixer;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected HashOrderMixingStrategy orderMixer;

    public DoubleIntHashMap() {
        this(4);
    }

    public DoubleIntHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public DoubleIntHashMap(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.defaultStrategy());
    }

    public DoubleIntHashMap(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public DoubleIntHashMap(DoubleIntAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public int put(double key, int value) {
        double existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (Double.doubleToLongBits(key) == 0L) {
            this.hasEmptyKey = true;
            int previousValue = this.values[mask + 1];
            this.values[mask + 1] = value;
            return previousValue;
        }
        double[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                int previousValue = this.values[slot];
                this.values[slot] = value;
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            keys[slot] = key;
            this.values[slot] = value;
        }
        ++this.assigned;
        return 0;
    }

    @Override
    public int putAll(DoubleIntAssociativeContainer container) {
        int count = this.size();
        for (DoubleIntCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.size() - count;
    }

    @Override
    public int putAll(Iterable<? extends DoubleIntCursor> iterable) {
        int count = this.size();
        for (DoubleIntCursor doubleIntCursor : iterable) {
            this.put(doubleIntCursor.key, doubleIntCursor.value);
        }
        return this.size() - count;
    }

    public boolean putIfAbsent(double key, int value) {
        int keyIndex = this.indexOf(key);
        if (!this.indexExists(keyIndex)) {
            this.indexInsert(keyIndex, key, value);
            return true;
        }
        return false;
    }

    @Override
    public int putOrAdd(double key, int putValue, int incrementValue) {
        assert (this.assigned < this.mask + 1);
        int keyIndex = this.indexOf(key);
        if (this.indexExists(keyIndex)) {
            putValue = this.values[keyIndex] + incrementValue;
            this.indexReplace(keyIndex, putValue);
        } else {
            this.indexInsert(keyIndex, key, putValue);
        }
        return putValue;
    }

    @Override
    public int addTo(double key, int incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    @Override
    public int remove(double key) {
        double existing;
        int mask = this.mask;
        if (Double.doubleToLongBits(key) == 0L) {
            this.hasEmptyKey = false;
            int previousValue = this.values[mask + 1];
            this.values[mask + 1] = 0;
            return previousValue;
        }
        double[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                int previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    @Override
    public int removeAll(DoubleContainer other) {
        int before = this.size();
        if (other.size() >= this.size() && other instanceof DoubleLookupContainer) {
            if (this.hasEmptyKey && other.contains(0.0)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0;
            }
            double[] keys = this.keys;
            int slot = 0;
            int max = this.mask;
            while (slot <= max) {
                double existing = keys[slot];
                if (Double.doubleToLongBits(existing) != 0L && other.contains(existing)) {
                    this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
        } else {
            for (DoubleCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(DoubleIntPredicate predicate) {
        int before = this.size();
        int mask = this.mask;
        if (this.hasEmptyKey && predicate.apply(0.0, this.values[mask + 1])) {
            this.hasEmptyKey = false;
            this.values[mask + 1] = 0;
        }
        double[] keys = this.keys;
        int[] values = this.values;
        int slot = 0;
        while (slot <= mask) {
            double existing = keys[slot];
            if (Double.doubleToLongBits(existing) != 0L && predicate.apply(existing, values[slot])) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(DoublePredicate predicate) {
        int before = this.size();
        if (this.hasEmptyKey && predicate.apply(0.0)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0;
        }
        double[] keys = this.keys;
        int slot = 0;
        int max = this.mask;
        while (slot <= max) {
            double existing = keys[slot];
            if (Double.doubleToLongBits(existing) != 0L && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public int get(double key) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : 0;
        }
        double[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    @Override
    public int getOrDefault(double key, int defaultValue) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue;
        }
        double[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    @Override
    public boolean containsKey(double key) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            return this.hasEmptyKey;
        }
        double[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int indexOf(double key) {
        double existing;
        int mask = this.mask;
        if (Double.doubleToLongBits(key) == 0L) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        double[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(existing) == Double.doubleToLongBits(key)) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    @Override
    public boolean indexExists(int index) {
        assert (index < 0 || index >= 0 && index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    @Override
    public int indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return this.values[index];
    }

    @Override
    public int indexReplace(int index, int newValue) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        int previousValue = this.values[index];
        this.values[index] = newValue;
        return previousValue;
    }

    @Override
    public void indexInsert(int index, double key, int value) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (Double.doubleToLongBits(key) == 0L) {
            assert (index == this.mask + 1);
            this.values[index] = value;
            this.hasEmptyKey = true;
        } else {
            assert (Double.doubleToLongBits(this.keys[index]) == 0L);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key, value);
            } else {
                this.keys[index] = key;
                this.values[index] = value;
            }
            ++this.assigned;
        }
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0.0);
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (DoubleIntCursor c : this) {
            h += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((DoubleIntHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(DoubleIntHashMap other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (DoubleIntCursor c : other) {
            double key = c.key;
            if (this.containsKey(key) && this.get(key) == c.value) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            double[] prevKeys = this.keys;
            int[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    @Override
    public Iterator<DoubleIntCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends DoubleIntProcedure> T forEach(T procedure) {
        double[] keys = this.keys;
        int[] values = this.values;
        if (this.hasEmptyKey) {
            procedure.apply(0.0, values[this.mask + 1]);
        }
        int max = this.mask;
        for (int slot = 0; slot <= max; ++slot) {
            if (Double.doubleToLongBits(keys[slot]) == 0L) continue;
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends DoubleIntPredicate> T forEach(T predicate) {
        double[] keys = this.keys;
        int[] values = this.values;
        if (this.hasEmptyKey && !predicate.apply(0.0, values[this.mask + 1])) {
            return predicate;
        }
        int max = this.mask;
        for (int slot = 0; slot <= max && (Double.doubleToLongBits(keys[slot]) == 0L || predicate.apply(keys[slot], values[slot])); ++slot) {
        }
        return predicate;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public IntCollection values() {
        return new ValuesContainer();
    }

    public DoubleIntHashMap clone() {
        try {
            DoubleIntHashMap cloned = (DoubleIntHashMap)super.clone();
            cloned.keys = (double[])this.keys.clone();
            cloned.values = (int[])this.values.clone();
            cloned.hasEmptyKey = cloned.hasEmptyKey;
            cloned.orderMixer = this.orderMixer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (DoubleIntCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return DoubleBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters);
    }

    public static DoubleIntHashMap from(double[] keys, int[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        DoubleIntHashMap map = new DoubleIntHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    protected int hashKey(double key) {
        assert (Double.doubleToLongBits(key) != 0L);
        return BitMixer.mix(key, this.keyMixer);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(double[] fromKeys, int[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        double[] keys = this.keys;
        int[] values = this.values;
        int mask = this.mask;
        int from = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from];
        values[values.length - 1] = fromValues[from];
        while (--from >= 0) {
            double existing = fromKeys[from];
            if (Double.doubleToLongBits(existing) == 0L) continue;
            int slot = this.hashKey(existing) & mask;
            while (Double.doubleToLongBits(keys[slot]) != 0L) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values[slot] = fromValues[from];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int newKeyMixer = this.orderMixer.newKeyMixer(arraySize);
        double[] prevKeys = this.keys;
        int[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new double[arraySize + emptyElementSlot];
            this.values = new int[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.keyMixer = newKeyMixer;
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, double pendingKey, int pendingValue) {
        assert (this.assigned == this.resizeAt && Double.doubleToLongBits(this.keys[slot]) == 0L && Double.doubleToLongBits(pendingKey) != 0L);
        double[] prevKeys = this.keys;
        int[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        double existing;
        double[] keys = this.keys;
        int[] values = this.values;
        int mask = this.mask;
        int distance = 0;
        while (Double.doubleToLongBits(existing = keys[slot = gapSlot + ++distance & mask]) != 0L) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = values[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0.0;
        values[gapSlot] = 0;
        --this.assigned;
    }

    private final class ValuesIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = DoubleIntHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntCursor();
        }

        @Override
        protected IntCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    if (Double.doubleToLongBits(DoubleIntHashMap.this.keys[this.slot]) != 0L) {
                        this.cursor.index = this.slot;
                        this.cursor.value = DoubleIntHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && DoubleIntHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = DoubleIntHashMap.this.values[this.max];
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractIntCollection {
        private final DoubleIntHashMap owner;

        private ValuesContainer() {
            this.owner = DoubleIntHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(int value) {
            for (DoubleIntCursor c : this.owner) {
                if (c.value != value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            for (DoubleIntCursor c : this.owner) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            for (DoubleIntCursor c : this.owner) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(final int e) {
            return this.owner.removeAll(new DoubleIntPredicate(){

                @Override
                public boolean apply(double key, int value) {
                    return value == e;
                }
            });
        }

        @Override
        public int removeAll(final IntPredicate predicate) {
            return this.owner.removeAll(new DoubleIntPredicate(){

                @Override
                public boolean apply(double key, int value) {
                    return predicate.apply(value);
                }
            });
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = DoubleIntHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new DoubleCursor();
        }

        @Override
        protected DoubleCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    double existing = DoubleIntHashMap.this.keys[this.slot];
                    if (Double.doubleToLongBits(existing) != 0L) {
                        this.cursor.index = this.slot;
                        this.cursor.value = existing;
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && DoubleIntHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0.0;
                return this.cursor;
            }
            return (DoubleCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractDoubleCollection
    implements DoubleLookupContainer {
        private final DoubleIntHashMap owner;

        public KeysContainer() {
            this.owner = DoubleIntHashMap.this;
        }

        @Override
        public boolean contains(double e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends DoubleProcedure> T forEach(final T procedure) {
            this.owner.forEach(new DoubleIntProcedure(){

                @Override
                public void apply(double key, int value) {
                    procedure.apply(key);
                }
            });
            return procedure;
        }

        @Override
        public <T extends DoublePredicate> T forEach(final T predicate) {
            this.owner.forEach(new DoubleIntPredicate(){

                @Override
                public boolean apply(double key, int value) {
                    return predicate.apply(key);
                }
            });
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<DoubleCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(DoublePredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(double e) {
            boolean hasKey = this.owner.containsKey(e);
            if (hasKey) {
                this.owner.remove(e);
                return 1;
            }
            return 0;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<DoubleIntCursor> {
        private final DoubleIntCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = DoubleIntHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new DoubleIntCursor();
        }

        @Override
        protected DoubleIntCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    double existing = DoubleIntHashMap.this.keys[this.slot];
                    if (Double.doubleToLongBits(existing) != 0L) {
                        this.cursor.index = this.slot;
                        this.cursor.key = existing;
                        this.cursor.value = DoubleIntHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && DoubleIntHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0.0;
                this.cursor.value = DoubleIntHashMap.this.values[this.max];
                return this.cursor;
            }
            return (DoubleIntCursor)this.done();
        }
    }
}

