/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.mpxj.DataType;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;
import net.sf.mpxj.GenericCriteria;
import net.sf.mpxj.GenericCriteriaPrompt;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.TestOperator;
import net.sf.mpxj.mpp.MPPUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CriteriaReader {
    private ProjectProperties m_properties;
    private byte[] m_criteriaData;
    private boolean[] m_criteriaType;
    private int m_criteriaTextStart;
    private int m_dataOffset;
    private List<GenericCriteriaPrompt> m_prompts;
    private List<FieldType> m_fields;
    protected Map<Integer, byte[]> m_criteriaBlockMap = new TreeMap<Integer, byte[]>();

    protected abstract int getCriteriaStartOffset();

    protected abstract int getCriteriaBlockSize();

    protected abstract byte[] getChildBlock(byte[] var1);

    protected abstract byte[] getListNextBlock(byte[] var1);

    protected abstract int getTextOffset(byte[] var1);

    protected abstract int getPromptOffset(byte[] var1);

    protected abstract int getValueOffset();

    protected abstract int getTimeUnitsOffset();

    protected abstract int getCriteriaTextStartOffset();

    protected abstract FieldType getFieldType(byte[] var1);

    public GenericCriteria process(ProjectProperties projectProperties, byte[] byArray, int n, int n2, List<GenericCriteriaPrompt> list, List<FieldType> list2, boolean[] blArray) {
        Object object;
        this.m_properties = projectProperties;
        this.m_prompts = list;
        this.m_fields = list2;
        this.m_criteriaType = blArray;
        this.m_dataOffset = n;
        if (this.m_criteriaType != null) {
            this.m_criteriaType[0] = true;
            this.m_criteriaType[1] = true;
        }
        this.m_criteriaBlockMap.clear();
        this.m_criteriaData = byArray;
        this.m_criteriaTextStart = MPPUtility.getShort(this.m_criteriaData, this.m_dataOffset + this.getCriteriaTextStartOffset());
        int n3 = this.getCriteriaStartOffset();
        int n4 = this.getCriteriaBlockSize();
        if (this.m_criteriaData.length <= this.m_criteriaTextStart) {
            return null;
        }
        while (n3 + n4 <= this.m_criteriaTextStart) {
            object = new byte[n4];
            System.arraycopy(this.m_criteriaData, this.m_dataOffset + n3, object, 0, n4);
            this.m_criteriaBlockMap.put(n3, (byte[])object);
            n3 += n4;
        }
        if (n2 == -1) {
            n2 = this.getCriteriaStartOffset();
        }
        object = new LinkedList();
        this.processBlock((List<GenericCriteria>)object, this.m_criteriaBlockMap.get(n2));
        GenericCriteria genericCriteria = object.isEmpty() ? null : (GenericCriteria)object.get(0);
        return genericCriteria;
    }

    private void processBlock(List<GenericCriteria> list, byte[] byArray) {
        if (byArray != null) {
            if (MPPUtility.getShort(byArray, 0) > 998) {
                this.addCriteria(list, byArray);
            } else {
                switch (byArray[0]) {
                    case 11: {
                        this.processBlock(list, this.getChildBlock(byArray));
                        break;
                    }
                    case 6: {
                        this.processBlock(list, this.getListNextBlock(byArray));
                        break;
                    }
                    case -19: {
                        this.addCriteria(list, byArray);
                        break;
                    }
                    case 25: 
                    case 27: {
                        this.addBlock(list, byArray, TestOperator.AND);
                        break;
                    }
                    case 26: 
                    case 28: {
                        this.addBlock(list, byArray, TestOperator.OR);
                    }
                }
            }
        }
    }

    private void addCriteria(List<GenericCriteria> list, byte[] byArray) {
        byte[] byArray2 = this.getChildBlock(byArray);
        byte[] byArray3 = this.getListNextBlock(byArray2);
        byte[] byArray4 = this.getListNextBlock(byArray3);
        TestOperator testOperator = TestOperator.getInstance(MPPUtility.getShort(byArray, 0) - 999);
        FieldType fieldType = this.getFieldType(byArray2);
        Object object = this.getValue(fieldType, byArray3);
        Object object2 = byArray4 == null ? null : this.getValue(fieldType, byArray4);
        GenericCriteria genericCriteria = new GenericCriteria(this.m_properties);
        genericCriteria.setLeftValue(fieldType);
        genericCriteria.setOperator(testOperator);
        genericCriteria.setRightValue(0, object);
        genericCriteria.setRightValue(1, object2);
        list.add(genericCriteria);
        if (this.m_criteriaType != null) {
            this.m_criteriaType[0] = fieldType.getFieldTypeClass() == FieldTypeClass.TASK;
            boolean bl = this.m_criteriaType[1] = !this.m_criteriaType[0];
        }
        if (this.m_fields != null) {
            this.m_fields.add(fieldType);
        }
        this.processBlock(list, this.getListNextBlock(byArray));
    }

    private void addBlock(List<GenericCriteria> list, byte[] byArray, TestOperator testOperator) {
        GenericCriteria genericCriteria = new GenericCriteria(this.m_properties);
        genericCriteria.setOperator(testOperator);
        list.add(genericCriteria);
        this.processBlock(genericCriteria.getCriteriaList(), this.getChildBlock(byArray));
        this.processBlock(list, this.getListNextBlock(byArray));
    }

    private Object getValue(FieldType fieldType, byte[] byArray) {
        Object object = null;
        switch (byArray[0]) {
            case 7: {
                object = this.getFieldType(byArray);
                break;
            }
            case 1: {
                object = this.getConstantValue(fieldType, byArray);
                break;
            }
            case 0: {
                object = this.getPromptValue(fieldType, byArray);
            }
        }
        return object;
    }

    private Object getConstantValue(FieldType fieldType, byte[] byArray) {
        Object object;
        DataType dataType = fieldType.getDataType();
        if (dataType == null) {
            object = null;
        } else {
            switch (dataType) {
                case DURATION: {
                    object = MPPUtility.getAdjustedDuration(this.m_properties, MPPUtility.getInt(byArray, this.getValueOffset()), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray, this.getTimeUnitsOffset())));
                    break;
                }
                case NUMERIC: {
                    object = MPPUtility.getDouble(byArray, this.getValueOffset());
                    break;
                }
                case PERCENTAGE: {
                    object = (double)MPPUtility.getShort(byArray, this.getValueOffset());
                    break;
                }
                case CURRENCY: {
                    object = MPPUtility.getDouble(byArray, this.getValueOffset()) / 100.0;
                    break;
                }
                case STRING: {
                    int n = this.getTextOffset(byArray);
                    object = MPPUtility.getUnicodeString(this.m_criteriaData, this.m_dataOffset + this.m_criteriaTextStart + n);
                    break;
                }
                case BOOLEAN: {
                    int n = MPPUtility.getShort(byArray, this.getValueOffset());
                    object = n == 1 ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case DATE: {
                    object = MPPUtility.getTimestamp(byArray, this.getValueOffset());
                    break;
                }
                default: {
                    object = null;
                }
            }
        }
        return object;
    }

    private GenericCriteriaPrompt getPromptValue(FieldType fieldType, byte[] byArray) {
        int n = this.getPromptOffset(byArray);
        String string = MPPUtility.getUnicodeString(this.m_criteriaData, this.m_criteriaTextStart + n);
        GenericCriteriaPrompt genericCriteriaPrompt = new GenericCriteriaPrompt(fieldType.getDataType(), string);
        if (this.m_prompts != null) {
            this.m_prompts.add(genericCriteriaPrompt);
        }
        return genericCriteriaPrompt;
    }
}

