/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet.editor;

import com.projity.field.Field;
import com.projity.field.FieldConverter;
import com.projity.field.FieldParseException;
import com.projity.options.CalendarOption;
import com.projity.options.EditOption;
import com.projity.pm.graphic.frames.GraphicManager;
import com.projity.pm.graphic.spreadsheet.SpreadSheetModel;
import com.projity.pm.graphic.spreadsheet.editor.KeyboardFocusable;
import com.projity.strings.Messages;
import com.projity.util.Alert;
import com.projity.util.DateTime;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.sf.nachocalendar.components.DateField;
import net.sf.nachocalendar.table.DateFieldTableEditor;

public class DateEditor
extends DateFieldTableEditor {
    protected ExtDateField dateField;
    private Date initialValue = null;

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        Field field = ((SpreadSheetModel)jTable.getModel()).getFieldInColumn(n2 + 1);
        DateFormat dateFormat = field.isDateOnly() ? EditOption.getInstance().getShortDateFormat() : EditOption.getInstance().getDateFormat();
        this.dateField = new ExtDateField(dateFormat);
        this.dateField.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        if (object == null) {
            long l = DateTime.midnightToday();
            if (field.isStartValue()) {
                l = CalendarOption.getInstance().makeValidStart(l, true);
            } else if (field.isEndValue()) {
                l = CalendarOption.getInstance().makeValidEnd(l, true);
            }
            object = new Date(l);
        }
        this.dateField.setValue(object);
        this.dateField.getTextField().setSelectedTextColor(Color.WHITE);
        this.dateField.getTextField().setSelectionColor(Color.BLACK);
        this.initialValue = (Date)object;
        return this.dateField;
    }

    public Object getCellEditorValue() {
        return this.dateField.getValue();
    }

    public boolean stopCellEditing() {
        Date date;
        String string = this.dateField.getFormattedTextField().getText();
        if (string.equals("")) {
            if (this.initialValue == null) {
                this.cancelCellEditing();
                return true;
            }
            return super.stopCellEditing();
        }
        try {
            date = (Date)FieldConverter.convert(string, Date.class, null);
        }
        catch (FieldParseException fieldParseException) {
            this.cancelCellEditing();
            Alert.warn(Messages.getString("Message.invalidDate"), this.dateField);
            return true;
        }
        if (date.equals(this.initialValue)) {
            this.cancelCellEditing();
            return true;
        }
        this.dateField.setValue(date);
        return super.stopCellEditing();
    }

    public static class ExtDateField
    extends DateField
    implements KeyboardFocusable {
        public ExtDateField(DateFormat dateFormat) {
            super(dateFormat);
            this.addMouseListener();
        }

        public ExtDateField() {
            this.addMouseListener();
        }

        private void addMouseListener() {
            this.getTextField().addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        GraphicManager.getInstance(ExtDateField.this).doInformationDialog(false);
                    }
                }
            });
        }

        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            if (Character.isDefined(keyStroke.getKeyChar())) {
                this.getTextField().dispatchEvent(keyEvent);
                return true;
            }
            return super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }

        public void requestFocus() {
            this.getTextField().requestFocus();
        }

        JTextField getTextField() {
            return this.getFormattedTextField();
        }

        public void selectAll(boolean bl) {
            if (bl) {
                this.getTextField().selectAll();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ExtDateField.this.getTextField().selectAll();
                    }
                });
            }
        }

        public String toString() {
            return this.getTextField().getText();
        }
    }
}

