/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * pow(vec3(0.0, 0.0, 0.66666669), vec3(0.66666669, 2.0, -2.0)) => vec3(0.0, 0.0, 2.2499998)
 * pow(vec3(0.66666669, 0.66666669, 0.66666669), vec3(-0.66666669, 0.66666669, 2.0)) => vec3(1.3103707, 0.76314282, 0.44444448)
 * pow(vec3(1.3333334, 1.3333334, 1.3333334), vec3(-2.0, -0.66666669, 0.66666669)) => vec3(0.56249994, 0.82548177, 1.2114137)
 * pow(vec3(1.3333334, 2.0, 2.0), vec3(2.0, -2.0, -0.66666669)) => vec3(1.7777779, 0.25, 0.62996054)
 * pow(vec3(2.0, 2.0, 0.0), vec3(0.66666669, 2.0, 0.66666669)) => vec3(1.587401, 4.0, 0.0)
 */
#version 150

void main()
{
  float[distance(pow(vec3(0.0, 0.0, 0.66666669), vec3(0.66666669, 2.0, -2.0)), vec3(0.0, 0.0, 2.2499998)) <= 2.2499999e-05 ? 1 : -1] array0;
  float[distance(pow(vec3(0.66666669, 0.66666669, 0.66666669), vec3(-0.66666669, 0.66666669, 2.0)), vec3(1.3103707, 0.76314282, 0.44444448)) <= 1.5801865e-05 ? 1 : -1] array1;
  float[distance(pow(vec3(1.3333334, 1.3333334, 1.3333334), vec3(-2.0, -0.66666669, 0.66666669)), vec3(0.56249994, 0.82548177, 1.2114137)) <= 1.5701431e-05 ? 1 : -1] array2;
  float[distance(pow(vec3(1.3333334, 2.0, 2.0), vec3(2.0, -2.0, -0.66666669)), vec3(1.7777779, 0.25, 0.62996054)) <= 1.9025889e-05 ? 1 : -1] array3;
  float[distance(pow(vec3(2.0, 2.0, 0.0), vec3(0.66666669, 2.0, 0.66666669)), vec3(1.587401, 4.0, 0.0)) <= 4.3034684e-05 ? 1 : -1] array4;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length());
}
