/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * length(0.0) => 0.0
 * length(-1.33) => 1.33
 * length(0.85000002) => 0.85000002
 */
#version 150

void main()
{
  float[distance(length(0.0), 0.0) <= 0.0 ? 1 : -1] array0;
  float[distance(length(-1.33), 1.33) <= 1.33e-05 ? 1 : -1] array1;
  float[distance(length(0.85000002), 0.85000002) <= 8.5000001e-06 ? 1 : -1] array2;
  gl_Position = vec4(array0.length() + array1.length() + array2.length());
}
