/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * faceforward(0.0, 0.0, 0.0) => -0.0
 * faceforward(0.0, 0.0, -1.33) => -0.0
 * faceforward(0.0, 0.0, 0.85000002) => -0.0
 * faceforward(0.0, -1.33, 0.0) => -0.0
 * faceforward(0.0, -1.33, -1.33) => -0.0
 * faceforward(0.0, -1.33, 0.85000002) => 0.0
 * faceforward(0.0, 0.85000002, 0.0) => -0.0
 * faceforward(0.0, 0.85000002, -1.33) => 0.0
 * faceforward(0.0, 0.85000002, 0.85000002) => -0.0
 * faceforward(-1.33, 0.0, 0.0) => 1.33
 * faceforward(-1.33, 0.0, -1.33) => 1.33
 * faceforward(-1.33, 0.0, 0.85000002) => 1.33
 * faceforward(-1.33, -1.33, 0.0) => 1.33
 * faceforward(-1.33, -1.33, -1.33) => 1.33
 * faceforward(-1.33, -1.33, 0.85000002) => -1.33
 * faceforward(-1.33, 0.85000002, 0.0) => 1.33
 * faceforward(-1.33, 0.85000002, -1.33) => -1.33
 * faceforward(-1.33, 0.85000002, 0.85000002) => 1.33
 * faceforward(0.85000002, 0.0, 0.0) => -0.85000002
 * faceforward(0.85000002, 0.0, -1.33) => -0.85000002
 * faceforward(0.85000002, 0.0, 0.85000002) => -0.85000002
 * faceforward(0.85000002, -1.33, 0.0) => -0.85000002
 * faceforward(0.85000002, -1.33, -1.33) => -0.85000002
 * faceforward(0.85000002, -1.33, 0.85000002) => 0.85000002
 * faceforward(0.85000002, 0.85000002, 0.0) => -0.85000002
 * faceforward(0.85000002, 0.85000002, -1.33) => 0.85000002
 * faceforward(0.85000002, 0.85000002, 0.85000002) => -0.85000002
 */
#version 150

void main()
{
  float[distance(faceforward(0.0, 0.0, 0.0), -0.0) <= 0.0 ? 1 : -1] array0;
  float[distance(faceforward(0.0, 0.0, -1.33), -0.0) <= 0.0 ? 1 : -1] array1;
  float[distance(faceforward(0.0, 0.0, 0.85000002), -0.0) <= 0.0 ? 1 : -1] array2;
  float[distance(faceforward(0.0, -1.33, 0.0), -0.0) <= 0.0 ? 1 : -1] array3;
  float[distance(faceforward(0.0, -1.33, -1.33), -0.0) <= 0.0 ? 1 : -1] array4;
  float[distance(faceforward(0.0, -1.33, 0.85000002), 0.0) <= 0.0 ? 1 : -1] array5;
  float[distance(faceforward(0.0, 0.85000002, 0.0), -0.0) <= 0.0 ? 1 : -1] array6;
  float[distance(faceforward(0.0, 0.85000002, -1.33), 0.0) <= 0.0 ? 1 : -1] array7;
  float[distance(faceforward(0.0, 0.85000002, 0.85000002), -0.0) <= 0.0 ? 1 : -1] array8;
  float[distance(faceforward(-1.33, 0.0, 0.0), 1.33) <= 1.33e-05 ? 1 : -1] array9;
  float[distance(faceforward(-1.33, 0.0, -1.33), 1.33) <= 1.33e-05 ? 1 : -1] array10;
  float[distance(faceforward(-1.33, 0.0, 0.85000002), 1.33) <= 1.33e-05 ? 1 : -1] array11;
  float[distance(faceforward(-1.33, -1.33, 0.0), 1.33) <= 1.33e-05 ? 1 : -1] array12;
  float[distance(faceforward(-1.33, -1.33, -1.33), 1.33) <= 1.33e-05 ? 1 : -1] array13;
  float[distance(faceforward(-1.33, -1.33, 0.85000002), -1.33) <= 1.33e-05 ? 1 : -1] array14;
  float[distance(faceforward(-1.33, 0.85000002, 0.0), 1.33) <= 1.33e-05 ? 1 : -1] array15;
  float[distance(faceforward(-1.33, 0.85000002, -1.33), -1.33) <= 1.33e-05 ? 1 : -1] array16;
  float[distance(faceforward(-1.33, 0.85000002, 0.85000002), 1.33) <= 1.33e-05 ? 1 : -1] array17;
  float[distance(faceforward(0.85000002, 0.0, 0.0), -0.85000002) <= 8.5000001e-06 ? 1 : -1] array18;
  float[distance(faceforward(0.85000002, 0.0, -1.33), -0.85000002) <= 8.5000001e-06 ? 1 : -1] array19;
  float[distance(faceforward(0.85000002, 0.0, 0.85000002), -0.85000002) <= 8.5000001e-06 ? 1 : -1] array20;
  float[distance(faceforward(0.85000002, -1.33, 0.0), -0.85000002) <= 8.5000001e-06 ? 1 : -1] array21;
  float[distance(faceforward(0.85000002, -1.33, -1.33), -0.85000002) <= 8.5000001e-06 ? 1 : -1] array22;
  float[distance(faceforward(0.85000002, -1.33, 0.85000002), 0.85000002) <= 8.5000001e-06 ? 1 : -1] array23;
  float[distance(faceforward(0.85000002, 0.85000002, 0.0), -0.85000002) <= 8.5000001e-06 ? 1 : -1] array24;
  float[distance(faceforward(0.85000002, 0.85000002, -1.33), 0.85000002) <= 8.5000001e-06 ? 1 : -1] array25;
  float[distance(faceforward(0.85000002, 0.85000002, 0.85000002), -0.85000002) <= 8.5000001e-06 ? 1 : -1] array26;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length() + array24.length() + array25.length() + array26.length());
}
