/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (dvec2(-0.10000000000000001lf, -1.2lf) / dvec2(-0.10000000000000001lf, -1.2lf)) => dvec2(1.0lf, 1.0lf)
 * (dvec2(-0.10000000000000001lf, -1.2lf) / dvec2(-0.41999999999999998lf, 0.47999999999999998lf)) => dvec2(0.23809523809523811lf, -2.5lf)
 * (dvec2(-0.41999999999999998lf, 0.47999999999999998lf) / dvec2(-0.10000000000000001lf, -1.2lf)) => dvec2(4.1999999999999993lf, -0.40000000000000002lf)
 * (dvec2(-0.41999999999999998lf, 0.47999999999999998lf) / dvec2(-0.41999999999999998lf, 0.47999999999999998lf)) => dvec2(1.0lf, 1.0lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((dvec2(-0.10000000000000001lf, -1.2lf) / dvec2(-0.10000000000000001lf, -1.2lf)), dvec2(1.0lf, 1.0lf)) <= 1.4142135623730953e-05lf ? 1 : -1] array0;
  double[distance((dvec2(-0.10000000000000001lf, -1.2lf) / dvec2(-0.41999999999999998lf, 0.47999999999999998lf)), dvec2(0.23809523809523811lf, -2.5lf)) <= 2.5113122749677371e-05lf ? 1 : -1] array1;
  double[distance((dvec2(-0.41999999999999998lf, 0.47999999999999998lf) / dvec2(-0.10000000000000001lf, -1.2lf)), dvec2(4.1999999999999993lf, -0.40000000000000002lf)) <= 4.2190046219457963e-05lf ? 1 : -1] array2;
  double[distance((dvec2(-0.41999999999999998lf, 0.47999999999999998lf) / dvec2(-0.41999999999999998lf, 0.47999999999999998lf)), dvec2(1.0lf, 1.0lf)) <= 1.4142135623730953e-05lf ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
