/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf)) => dmat4(-0.0lf, 0.0lf, 0.0lf, -0.0lf, -0.0lf, 0.0lf, -0.0lf, -0.0lf, -0.0lf, 0.0lf, -0.0lf, -0.0lf, 0.0lf, -0.0lf, -0.0lf, 0.0lf)
 * (0.0lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf)) => dmat4(0.0lf, 0.0lf, 0.0lf, -0.0lf, 0.0lf, -0.0lf, 0.0lf, 0.0lf, 0.0lf, 0.0lf, 0.0lf, -0.0lf, -0.0lf, -0.0lf, -0.0lf, 0.0lf)
 * (-1.3333333333333333lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf)) => dmat4(1.3333333333333333lf, -0.75329566854990582lf, -14.814814814814815lf, 1.4652014652014651lf, 2.4242424242424239lf, -2.150537634408602lf, 1.8779342723004695lf, 0.73260073260073255lf, 1.2345679012345678lf, -2.7777777777777777lf, 0.95923261390887293lf, 0.93240093240093236lf, -0.74487895716945995lf, 0.98765432098765416lf, 1.1019283746556474lf, -1.8518518518518519lf)
 * (-1.3333333333333333lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf)) => dmat4(-22.222222222222221lf, -0.83333333333333326lf, -1.0666666666666667lf, 8.3333333333333321lf, -1.0178117048346056lf, 4.1666666666666661lf, -2.9629629629629628lf, -2.9629629629629628lf, -0.8771929824561403lf, -2.6143790849673199lf, -0.70175438596491224lf, 1.5151515151515151lf, 0.68027210884353739lf, 0.72463768115942018lf, 1.8518518518518519lf, -3.4188034188034186lf)
 * (0.84999999999999998lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf)) => dmat4(-0.84999999999999998lf, 0.48022598870056493lf, 9.4444444444444446lf, -0.93406593406593397lf, -1.5454545454545452lf, 1.3709677419354838lf, -1.1971830985915493lf, -0.46703296703296698lf, -0.78703703703703698lf, 1.7708333333333333lf, -0.61151079136690645lf, -0.59440559440559437lf, 0.47486033519553073lf, -0.62962962962962954lf, -0.7024793388429752lf, 1.1805555555555556lf)
 * (0.84999999999999998lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf)) => dmat4(14.166666666666666lf, 0.53125lf, 0.67999999999999994lf, -5.3125lf, 0.64885496183206104lf, -2.65625lf, 1.8888888888888888lf, 1.8888888888888888lf, 0.55921052631578949lf, 1.6666666666666665lf, 0.44736842105263158lf, -0.96590909090909083lf, -0.43367346938775508lf, -0.46195652173913038lf, -1.1805555555555556lf, 2.1794871794871793lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[(distance((0.0lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[0], dvec4(-0.0lf, 0.0lf, 0.0lf, -0.0lf)) * distance((0.0lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[0], dvec4(-0.0lf, 0.0lf, 0.0lf, -0.0lf))) + (distance((0.0lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[1], dvec4(-0.0lf, 0.0lf, -0.0lf, -0.0lf)) * distance((0.0lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[1], dvec4(-0.0lf, 0.0lf, -0.0lf, -0.0lf))) + (distance((0.0lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[2], dvec4(-0.0lf, 0.0lf, -0.0lf, -0.0lf)) * distance((0.0lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[2], dvec4(-0.0lf, 0.0lf, -0.0lf, -0.0lf))) + (distance((0.0lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[3], dvec4(0.0lf, -0.0lf, -0.0lf, 0.0lf)) * distance((0.0lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[3], dvec4(0.0lf, -0.0lf, -0.0lf, 0.0lf))) <= 0.0lf ? 1 : -1] array0;
  double[(distance((0.0lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[0], dvec4(0.0lf, 0.0lf, 0.0lf, -0.0lf)) * distance((0.0lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[0], dvec4(0.0lf, 0.0lf, 0.0lf, -0.0lf))) + (distance((0.0lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[1], dvec4(0.0lf, -0.0lf, 0.0lf, 0.0lf)) * distance((0.0lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[1], dvec4(0.0lf, -0.0lf, 0.0lf, 0.0lf))) + (distance((0.0lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[2], dvec4(0.0lf, 0.0lf, 0.0lf, -0.0lf)) * distance((0.0lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[2], dvec4(0.0lf, 0.0lf, 0.0lf, -0.0lf))) + (distance((0.0lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[3], dvec4(-0.0lf, -0.0lf, -0.0lf, 0.0lf)) * distance((0.0lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[3], dvec4(-0.0lf, -0.0lf, -0.0lf, 0.0lf))) <= 0.0lf ? 1 : -1] array1;
  double[(distance((-1.3333333333333333lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[0], dvec4(1.3333333333333333lf, -0.75329566854990582lf, -14.814814814814815lf, 1.4652014652014651lf)) * distance((-1.3333333333333333lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[0], dvec4(1.3333333333333333lf, -0.75329566854990582lf, -14.814814814814815lf, 1.4652014652014651lf))) + (distance((-1.3333333333333333lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[1], dvec4(2.4242424242424239lf, -2.150537634408602lf, 1.8779342723004695lf, 0.73260073260073255lf)) * distance((-1.3333333333333333lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[1], dvec4(2.4242424242424239lf, -2.150537634408602lf, 1.8779342723004695lf, 0.73260073260073255lf))) + (distance((-1.3333333333333333lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[2], dvec4(1.2345679012345678lf, -2.7777777777777777lf, 0.95923261390887293lf, 0.93240093240093236lf)) * distance((-1.3333333333333333lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[2], dvec4(1.2345679012345678lf, -2.7777777777777777lf, 0.95923261390887293lf, 0.93240093240093236lf))) + (distance((-1.3333333333333333lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[3], dvec4(-0.74487895716945995lf, 0.98765432098765416lf, 1.1019283746556474lf, -1.8518518518518519lf)) * distance((-1.3333333333333333lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[3], dvec4(-0.74487895716945995lf, 0.98765432098765416lf, 1.1019283746556474lf, -1.8518518518518519lf))) <= 2.5573950302039242e-08lf ? 1 : -1] array2;
  double[(distance((-1.3333333333333333lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[0], dvec4(-22.222222222222221lf, -0.83333333333333326lf, -1.0666666666666667lf, 8.3333333333333321lf)) * distance((-1.3333333333333333lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[0], dvec4(-22.222222222222221lf, -0.83333333333333326lf, -1.0666666666666667lf, 8.3333333333333321lf))) + (distance((-1.3333333333333333lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[1], dvec4(-1.0178117048346056lf, 4.1666666666666661lf, -2.9629629629629628lf, -2.9629629629629628lf)) * distance((-1.3333333333333333lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[1], dvec4(-1.0178117048346056lf, 4.1666666666666661lf, -2.9629629629629628lf, -2.9629629629629628lf))) + (distance((-1.3333333333333333lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[2], dvec4(-0.8771929824561403lf, -2.6143790849673199lf, -0.70175438596491224lf, 1.5151515151515151lf)) * distance((-1.3333333333333333lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[2], dvec4(-0.8771929824561403lf, -2.6143790849673199lf, -0.70175438596491224lf, 1.5151515151515151lf))) + (distance((-1.3333333333333333lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[3], dvec4(0.68027210884353739lf, 0.72463768115942018lf, 1.8518518518518519lf, -3.4188034188034186lf)) * distance((-1.3333333333333333lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[3], dvec4(0.68027210884353739lf, 0.72463768115942018lf, 1.8518518518518519lf, -3.4188034188034186lf))) <= 6.2755720884701124e-08lf ? 1 : -1] array3;
  double[(distance((0.84999999999999998lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[0], dvec4(-0.84999999999999998lf, 0.48022598870056493lf, 9.4444444444444446lf, -0.93406593406593397lf)) * distance((0.84999999999999998lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[0], dvec4(-0.84999999999999998lf, 0.48022598870056493lf, 9.4444444444444446lf, -0.93406593406593397lf))) + (distance((0.84999999999999998lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[1], dvec4(-1.5454545454545452lf, 1.3709677419354838lf, -1.1971830985915493lf, -0.46703296703296698lf)) * distance((0.84999999999999998lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[1], dvec4(-1.5454545454545452lf, 1.3709677419354838lf, -1.1971830985915493lf, -0.46703296703296698lf))) + (distance((0.84999999999999998lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[2], dvec4(-0.78703703703703698lf, 1.7708333333333333lf, -0.61151079136690645lf, -0.59440559440559437lf)) * distance((0.84999999999999998lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[2], dvec4(-0.78703703703703698lf, 1.7708333333333333lf, -0.61151079136690645lf, -0.59440559440559437lf))) + (distance((0.84999999999999998lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[3], dvec4(0.47486033519553073lf, -0.62962962962962954lf, -0.7024793388429752lf, 1.1805555555555556lf)) * distance((0.84999999999999998lf / dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[3], dvec4(0.47486033519553073lf, -0.62962962962962954lf, -0.7024793388429752lf, 1.1805555555555556lf))) <= 1.0393413239938136e-08lf ? 1 : -1] array4;
  double[(distance((0.84999999999999998lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[0], dvec4(14.166666666666666lf, 0.53125lf, 0.67999999999999994lf, -5.3125lf)) * distance((0.84999999999999998lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[0], dvec4(14.166666666666666lf, 0.53125lf, 0.67999999999999994lf, -5.3125lf))) + (distance((0.84999999999999998lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[1], dvec4(0.64885496183206104lf, -2.65625lf, 1.8888888888888888lf, 1.8888888888888888lf)) * distance((0.84999999999999998lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[1], dvec4(0.64885496183206104lf, -2.65625lf, 1.8888888888888888lf, 1.8888888888888888lf))) + (distance((0.84999999999999998lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[2], dvec4(0.55921052631578949lf, 1.6666666666666665lf, 0.44736842105263158lf, -0.96590909090909083lf)) * distance((0.84999999999999998lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[2], dvec4(0.55921052631578949lf, 1.6666666666666665lf, 0.44736842105263158lf, -0.96590909090909083lf))) + (distance((0.84999999999999998lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[3], dvec4(-0.43367346938775508lf, -0.46195652173913038lf, -1.1805555555555556lf, 2.1794871794871793lf)) * distance((0.84999999999999998lf / dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[3], dvec4(-0.43367346938775508lf, -0.46195652173913038lf, -1.1805555555555556lf, 2.1794871794871793lf))) <= 2.5504317190798062e-08lf ? 1 : -1] array5;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
