/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * max(-2.0lf, -2.0lf) => -2.0lf
 * max(-2.0lf, -0.66666666666666674lf) => -0.66666666666666674lf
 * max(-2.0lf, 0.66666666666666652lf) => 0.66666666666666652lf
 * max(-2.0lf, 2.0lf) => 2.0lf
 * max(-0.66666666666666674lf, -2.0lf) => -0.66666666666666674lf
 * max(-0.66666666666666674lf, -0.66666666666666674lf) => -0.66666666666666674lf
 * max(-0.66666666666666674lf, 0.66666666666666652lf) => 0.66666666666666652lf
 * max(-0.66666666666666674lf, 2.0lf) => 2.0lf
 * max(0.66666666666666652lf, -2.0lf) => 0.66666666666666652lf
 * max(0.66666666666666652lf, -0.66666666666666674lf) => 0.66666666666666652lf
 * max(0.66666666666666652lf, 0.66666666666666652lf) => 0.66666666666666652lf
 * max(0.66666666666666652lf, 2.0lf) => 2.0lf
 * max(2.0lf, -2.0lf) => 2.0lf
 * max(2.0lf, -0.66666666666666674lf) => 2.0lf
 * max(2.0lf, 0.66666666666666652lf) => 2.0lf
 * max(2.0lf, 2.0lf) => 2.0lf
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(max(-2.0lf, -2.0lf), -2.0lf) <= 2.0000000000000002e-05lf ? 1 : -1] array0;
  double[distance(max(-2.0lf, -0.66666666666666674lf), -0.66666666666666674lf) <= 6.6666666666666683e-06lf ? 1 : -1] array1;
  double[distance(max(-2.0lf, 0.66666666666666652lf), 0.66666666666666652lf) <= 6.6666666666666658e-06lf ? 1 : -1] array2;
  double[distance(max(-2.0lf, 2.0lf), 2.0lf) <= 2.0000000000000002e-05lf ? 1 : -1] array3;
  double[distance(max(-0.66666666666666674lf, -2.0lf), -0.66666666666666674lf) <= 6.6666666666666683e-06lf ? 1 : -1] array4;
  double[distance(max(-0.66666666666666674lf, -0.66666666666666674lf), -0.66666666666666674lf) <= 6.6666666666666683e-06lf ? 1 : -1] array5;
  double[distance(max(-0.66666666666666674lf, 0.66666666666666652lf), 0.66666666666666652lf) <= 6.6666666666666658e-06lf ? 1 : -1] array6;
  double[distance(max(-0.66666666666666674lf, 2.0lf), 2.0lf) <= 2.0000000000000002e-05lf ? 1 : -1] array7;
  double[distance(max(0.66666666666666652lf, -2.0lf), 0.66666666666666652lf) <= 6.6666666666666658e-06lf ? 1 : -1] array8;
  double[distance(max(0.66666666666666652lf, -0.66666666666666674lf), 0.66666666666666652lf) <= 6.6666666666666658e-06lf ? 1 : -1] array9;
  double[distance(max(0.66666666666666652lf, 0.66666666666666652lf), 0.66666666666666652lf) <= 6.6666666666666658e-06lf ? 1 : -1] array10;
  double[distance(max(0.66666666666666652lf, 2.0lf), 2.0lf) <= 2.0000000000000002e-05lf ? 1 : -1] array11;
  double[distance(max(2.0lf, -2.0lf), 2.0lf) <= 2.0000000000000002e-05lf ? 1 : -1] array12;
  double[distance(max(2.0lf, -0.66666666666666674lf), 2.0lf) <= 2.0000000000000002e-05lf ? 1 : -1] array13;
  double[distance(max(2.0lf, 0.66666666666666652lf), 2.0lf) <= 2.0000000000000002e-05lf ? 1 : -1] array14;
  double[distance(max(2.0lf, 2.0lf), 2.0lf) <= 2.0000000000000002e-05lf ? 1 : -1] array15;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length());
}
