/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.merger.diff;

import java.util.ArrayList;
import org.openoffice.xmerge.merger.DiffAlgorithm;
import org.openoffice.xmerge.merger.Difference;
import org.openoffice.xmerge.merger.Iterator;
import org.openoffice.xmerge.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratorLCSAlgorithm
implements DiffAlgorithm {
    @Override
    public Difference[] computeDiffs(Iterator iterator, Iterator iterator2) {
        int n = iterator.elementCount();
        int n2 = iterator2.elementCount();
        int[][] nArray = this.createDiffTable(iterator, iterator2);
        if (Debug.isFlagSet(1)) {
            this.printDiffTable(nArray);
        }
        ArrayList<Difference> arrayList = new ArrayList<Difference>();
        this.generateResult(nArray, n, n2, arrayList);
        Difference[] differenceArray = new Difference[arrayList.size()];
        arrayList.toArray(differenceArray);
        return differenceArray;
    }

    private void printDiffTable(int[][] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int j = 0; j < nArray[i].length; ++j) {
                stringBuilder.append(" ").append(nArray[i][j]).append(" ");
            }
            Debug.log(1, stringBuilder.toString());
        }
    }

    private int[][] createDiffTable(Iterator iterator, Iterator iterator2) {
        int n;
        int n2 = iterator.elementCount() + 1;
        int n3 = iterator2.elementCount() + 1;
        int[][] nArrayArray = new int[n2][];
        for (n = 0; n < n2; ++n) {
            nArrayArray[n] = new int[n3];
        }
        Object object = iterator.start();
        n = 1;
        while (object != null) {
            Object object2 = iterator2.start();
            int n4 = 1;
            while (object2 != null) {
                nArrayArray[n][n4] = iterator.equivalent(object, object2) ? nArrayArray[n - 1][n4 - 1] + 1 : (nArrayArray[n - 1][n4] >= nArrayArray[n][n4 - 1] ? nArrayArray[n - 1][n4] : nArrayArray[n][n4 - 1]);
                object2 = iterator2.next();
                ++n4;
            }
            object = iterator.next();
            ++n;
        }
        return nArrayArray;
    }

    private void generateResult(int[][] nArray, int n, int n2, ArrayList<Difference> arrayList) {
        if (n == 0 && n2 == 0) {
            return;
        }
        if (n2 == 0) {
            for (int i = 0; i < n; ++i) {
                Difference difference = new Difference(2, i, n2);
                arrayList.add(difference);
            }
            return;
        }
        if (n == 0) {
            for (int i = 0; i < n2; ++i) {
                Difference difference = new Difference(1, n, i);
                arrayList.add(difference);
            }
            return;
        }
        if (nArray[n - 1][n2 - 1] == nArray[n][n2] - 1 && nArray[n - 1][n2 - 1] == nArray[n - 1][n2] && nArray[n - 1][n2 - 1] == nArray[n][n2 - 1]) {
            this.generateResult(nArray, n - 1, n2 - 1, arrayList);
        } else if (nArray[n - 1][n2] > nArray[n][n2 - 1]) {
            this.generateResult(nArray, n - 1, n2, arrayList);
            Difference difference = new Difference(2, n - 1, n2);
            arrayList.add(difference);
        } else if (nArray[n - 1][n2] < nArray[n][n2 - 1]) {
            this.generateResult(nArray, n, n2 - 1, arrayList);
            Difference difference = new Difference(1, n, n2 - 1);
            arrayList.add(difference);
        } else {
            this.generateResult(nArray, n - 1, n2 - 1, arrayList);
            Difference difference = new Difference(3, n - 1, n2 - 1);
            arrayList.add(difference);
        }
    }
}

