/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.report;

import com.sun.star.awt.TextEvent;
import com.sun.star.awt.XTextListener;
import com.sun.star.beans.PropertyValue;
import com.sun.star.container.XContentEnumerationAccess;
import com.sun.star.container.XEnumeration;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.logging.XLogger;
import com.sun.star.logging.XLoggerPool;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.InvalidQueryException;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.common.SystemDialog;
import com.sun.star.wizards.db.DBMetaData;
import com.sun.star.wizards.db.DatabaseObjectWizard;
import com.sun.star.wizards.db.RecordParser;
import com.sun.star.wizards.db.SQLQueryComposer;
import com.sun.star.wizards.report.Dataimport;
import com.sun.star.wizards.report.GroupFieldHandler;
import com.sun.star.wizards.report.IReportDocument;
import com.sun.star.wizards.report.ReportFinalizer;
import com.sun.star.wizards.report.ReportLayouter;
import com.sun.star.wizards.report.ReportTextImplementation;
import com.sun.star.wizards.ui.CommandFieldSelection;
import com.sun.star.wizards.ui.SortingComponent;
import com.sun.star.wizards.ui.TitlesComponent;
import com.sun.star.wizards.ui.UnoDialog;
import com.sun.star.wizards.ui.XFieldSelectionListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;

public class ReportWizard
extends DatabaseObjectWizard
implements XTextListener {
    private SortingComponent CurSortingComponent;
    private TitlesComponent CurTitlesComponent;
    private CommandFieldSelection CurDBCommandFieldSelection;
    private GroupFieldHandler CurGroupFieldHandler;
    private ReportLayouter CurReportLayouter;
    private ReportFinalizer CurReportFinalizer;
    private int nReportMode = 1;
    private String m_sReportName = PropertyNames.EMPTY_STRING;
    protected static final String SOREPORTFORMNAME = "ReportSource";
    private static final int SOMAINPAGE = 1;
    private static final int SOTITLEPAGE = 2;
    protected static final int SOGROUPPAGE = 3;
    private static final int SOSORTPAGE = 4;
    protected static final int SOTEMPLATEPAGE = 5;
    protected static final int SOSTOREPAGE = 6;
    private IReportDocument m_reportDocument;
    private static String sMsgWizardName;
    private static String slblFields;
    private static String slblSelFields;
    private static String sShowBinaryFields;
    private String[] WizardHeaderText = new String[6];
    private static String slblColumnTitles;
    private static String slblColumnNames;
    private static String slblTables;
    protected static boolean bCloseDocument;
    private boolean bHasEscapeProcessing = true;
    private static XLogger m_xLogger;

    public ReportWizard(XMultiServiceFactory xMultiServiceFactory, PropertyValue[] propertyValueArray) {
        super(xMultiServiceFactory, 34320, propertyValueArray);
        super.addResourceHandler();
        if (this.getReportResources(false)) {
            Helper.setUnoPropertyValues(this.xDialogModel, new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_MOVEABLE, PropertyNames.PROPERTY_NAME, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_TITLE, PropertyNames.PROPERTY_WIDTH}, new Object[]{210, Boolean.TRUE, "DialogReport", 102, 41, 1, (short)0, sMsgWizardName, 310});
            this.drawNaviBar();
            this.setRightPaneHeaders(this.WizardHeaderText);
        }
    }

    protected void enterStep(int n, int n2) {
        if (n >= 5 && n2 < 5) {
            this.m_reportDocument.removeTextTableAndTextSection();
        }
        switch (n2) {
            case 1: {
                this.CurDBCommandFieldSelection.setModified(false);
                break;
            }
            case 2: {
                String[] stringArray = this.m_reportDocument.getRecordParser().getFieldNames();
                Map<String, String> map = this.m_reportDocument.getRecordParser().getFieldTitleSet();
                this.CurTitlesComponent.initialize(stringArray, map);
                break;
            }
            case 3: {
                this.CurGroupFieldHandler.initialize();
                break;
            }
            case 4: {
                String[] stringArray = this.m_reportDocument.getRecordParser().getFieldNames();
                String[][] stringArray2 = this.m_reportDocument.getRecordParser().getSortFieldNames();
                this.CurSortingComponent.initialize(stringArray, stringArray2);
                int n3 = this.m_reportDocument.getRecordParser().GroupFieldNames.length;
                this.CurSortingComponent.setReadOnlyUntil(n3);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.CurReportFinalizer.initialize(this.m_reportDocument.getRecordParser());
                break;
            }
        }
    }

    protected void leaveStep(int n, int n2) {
        switch (n) {
            case 1: {
                String[] stringArray = this.CurDBCommandFieldSelection.getSelectedFieldNames();
                String string = this.CurDBCommandFieldSelection.getSelectedCommandName();
                int n3 = this.CurDBCommandFieldSelection.getSelectedCommandType();
                this.m_reportDocument.initializeFieldColumns(n3, string, stringArray);
                if (!this.CurDBCommandFieldSelection.isModified()) break;
                this.m_reportDocument.clearDocument();
                this.m_reportDocument.getRecordParser().setGroupFieldNames(new String[0]);
                this.CurGroupFieldHandler.removeGroupFieldNames();
                break;
            }
            case 2: {
                String[] stringArray = this.CurTitlesComponent.getFieldTitles();
                this.m_reportDocument.setFieldTitles(stringArray);
                break;
            }
            case 3: {
                this.CurGroupFieldHandler.getGroupFieldNames(this.m_reportDocument.getRecordParser());
                String[] stringArray = this.m_reportDocument.getRecordParser().GroupFieldNames;
                this.m_reportDocument.setGrouping(stringArray);
                break;
            }
            case 4: {
                String[][] stringArray = this.CurSortingComponent.getSortFieldNames();
                this.m_reportDocument.setSorting(stringArray);
                super.enablefromStep(5, true);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
        }
        if (n < 5 && super.getNewStep() >= 5) {
            this.m_reportDocument.getRecordParser().createRecordFieldNames();
            this.CurReportLayouter.initialize(this.m_reportDocument.getContentPath());
        }
    }

    private void dialogFinish() {
        this.xComponent.dispose();
        if (bCloseDocument) {
            this.m_reportDocument.dispose();
            return;
        }
        if (this.nReportMode == 2 || this.nReportMode == 3) {
            this.m_reportDocument.addReportToDBView();
            boolean bl = this.nReportMode == 2;
            this.m_reportDocument.createAndOpenReportDocument(this.m_sReportName, true, bl);
        } else {
            this.m_reportDocument.importReportData(this);
            this.m_reportDocument.createAndOpenReportDocument(this.m_sReportName, false, false);
        }
    }

    private boolean executeQuery() {
        boolean bl = false;
        RecordParser recordParser = this.m_reportDocument.getRecordParser();
        SQLQueryComposer sQLQueryComposer = recordParser.getSQLQueryComposer();
        if (this.CurDBCommandFieldSelection.getSelectedCommandType() == 0) {
            if (this.m_reportDocument instanceof ReportTextImplementation) {
                bl = sQLQueryComposer.setQueryCommand(this.xWindow, false, false);
                this.m_reportDocument.setCommandType(2);
                String string = sQLQueryComposer.getQuery();
                this.m_reportDocument.setCommand(string);
            } else {
                bl = true;
            }
        } else {
            try {
                String string = this.CurDBCommandFieldSelection.getSelectedCommandName();
                DBMetaData.CommandObject commandObject = recordParser.getQueryByName(string);
                this.bHasEscapeProcessing = recordParser.hasEscapeProcessing(commandObject.getPropertySet());
                String string2 = (String)commandObject.getPropertySet().getPropertyValue(PropertyNames.COMMAND);
                if (this.bHasEscapeProcessing) {
                    if (this.m_reportDocument instanceof ReportTextImplementation) {
                        sQLQueryComposer.m_xQueryAnalyzer.setQuery(string2);
                        sQLQueryComposer.prependSortingCriteria();
                        this.m_reportDocument.setCommandType(2);
                        this.m_reportDocument.setCommand(sQLQueryComposer.getQuery());
                    }
                } else {
                    this.m_reportDocument.setCommandType(2);
                    this.m_reportDocument.setCommand(string2);
                }
                bl = true;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        if (!bl) {
            super.vetoableChange(null);
        }
        return bl;
    }

    private void buildSteps() {
        this.CurDBCommandFieldSelection = new CommandFieldSelection(this, this.m_reportDocument.getRecordParser(), 100, slblFields, slblSelFields, slblTables, true, 34330);
        this.CurDBCommandFieldSelection.addFieldSelectionListener(new FieldSelectionListener());
        if (!this.isReportBuilderInstalled()) {
            this.insertLabel("lblBinaryFields", new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_WIDTH}, new Object[]{16, sShowBinaryFields, 95, 162, 1, 210});
        }
        this.CurTitlesComponent = new TitlesComponent(this, 2, 97, 37, 210, 7, slblColumnNames, slblColumnTitles, 34381);
        this.CurTitlesComponent.addTextListener(this);
        this.CurGroupFieldHandler = new GroupFieldHandler(this.m_reportDocument, this);
        this.CurSortingComponent = new SortingComponent(this, 4, 95, 30, 210, 34346);
        this.CurReportLayouter = new ReportLayouter(this.xMSF, this.m_reportDocument, this, this.isReportBuilderInstalled());
        this.CurReportFinalizer = new ReportFinalizer(this.m_reportDocument, this);
        bCloseDocument = true;
        this.enableNavigationButtons(false, false, false);
    }

    public boolean finishWizard() {
        int n = this.getCurrentStep();
        if ((this.switchToStep(n, 6) || n == 6) && this.executeQuery() && this.CurReportFinalizer.finish()) {
            this.nReportMode = this.CurReportFinalizer.getReportOpenMode();
            this.m_sReportName = this.CurReportFinalizer.getStoreName();
            this.xDialog.endExecute();
            return true;
        }
        return false;
    }

    public void cancelWizard() {
        this.xDialog.endExecute();
    }

    private void insertQueryRelatedSteps() {
        this.setRMItemLabels(this.m_oResource);
        this.addRoadmap();
        int n = 0;
        n = this.insertRoadmapItem(0, true, this.m_oResource.getResText("RID_QUERY_80"), 1);
        n = this.insertRoadmapItem(n, false, this.m_oResource.getResText("RID_REPORT_68"), 2);
        n = this.insertRoadmapItem(n, false, this.m_oResource.getResText("RID_REPORT_11"), 3);
        n = this.insertRoadmapItem(n, false, this.m_oResource.getResText("RID_REPORT_12"), 4);
        n = this.insertRoadmapItem(n, false, this.m_oResource.getResText("RID_REPORT_13"), 5);
        n = this.insertRoadmapItem(n, false, this.m_oResource.getResText("RID_REPORT_14"), 6);
        this.setRoadmapInteractive(true);
        this.setRoadmapComplete(true);
        this.setCurrentRoadmapItemID((short)1);
    }

    private boolean isReportBuilderInstalled() {
        XContentEnumerationAccess xContentEnumerationAccess = (XContentEnumerationAccess)UnoRuntime.queryInterface(XContentEnumerationAccess.class, (Object)this.xMSF);
        XEnumeration xEnumeration = xContentEnumerationAccess.createContentEnumeration("org.libreoffice.report.pentaho.SOReportJobFactory");
        if (xEnumeration == null) {
            return false;
        }
        return xEnumeration.hasMoreElements();
    }

    private static void initializeLogger(XMultiServiceFactory xMultiServiceFactory) {
        XComponentContext xComponentContext = Helper.getComponentContext(xMultiServiceFactory);
        Object object = xComponentContext.getValueByName("/singletons/com.sun.star.logging.LoggerPool");
        if (object == null) {
            System.out.println("Can't get singleton from logging");
        }
        XLoggerPool xLoggerPool = (XLoggerPool)UnoRuntime.queryInterface(XLoggerPool.class, (Object)object);
        m_xLogger = xLoggerPool.getNamedLogger("com.sun.star.wizards.ReportBuilder");
    }

    public static XLogger getLogger() {
        return m_xLogger;
    }

    public void startReportWizard() {
        Object object;
        ReportWizard.initializeLogger(this.xMSF);
        ReportWizard.getLogger().log(1000, "Start Report Wizard");
        if (this.isReportBuilderInstalled()) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName("com.sun.star.wizards.reportbuilder.ReportBuilderImplementation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("ReportBuilderImplementation is unavailable");
            }
            if (clazz != null) {
                try {
                    object = clazz.getMethod("create", XMultiServiceFactory.class);
                    this.m_reportDocument = (IReportDocument)((Method)object).invoke(clazz, this.xMSF);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        try {
            if (this.m_reportDocument == null) {
                this.m_reportDocument = new ReportTextImplementation(this.xMSF);
            }
            this.m_reportDocument.initialize(this.m_docUI, this.m_oResource);
            if (this.m_reportDocument.getRecordParser().getConnection(this.m_wizardContext)) {
                this.buildSteps();
                if (!this.isReportBuilderInstalled()) {
                    this.CurReportLayouter.drawConstants();
                }
                this.m_reportDocument.checkInvariants();
                this.CurDBCommandFieldSelection.preselectCommand(this.m_wizardContext, false);
                this.createWindowPeer(this.m_reportDocument.getWizardParent());
                this.m_reportDocument.getRecordParser().setWindowPeer(this.xControl.getPeer());
                this.insertQueryRelatedSteps();
                short s = this.executeDialog(this.m_reportDocument.getFrame().getComponentWindow().getPosSize());
                if (s == 0) {
                    this.dialogFinish();
                }
            }
            this.m_reportDocument.getRecordParser().dispose();
        }
        catch (IOException iOException) {
            object = iOException.getMessage();
            if (((String)object).equals("default.otr")) {
                object = this.m_oResource.getResText("RID_REPORT_92");
            }
            SystemDialog.showMessageBox(this.xMSF, "ErrorBox", 0x400000, (String)object);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void importReportData(XMultiServiceFactory xMultiServiceFactory, Dataimport dataimport) {
        boolean bl = false;
        try {
            boolean bl2 = false;
            bl2 = !this.bHasEscapeProcessing ? this.m_reportDocument.getRecordParser().executeCommand(1) : this.m_reportDocument.getRecordParser().executeCommand(2);
            if (bl2) {
                bl2 = this.m_reportDocument.getRecordParser().getFields(this.m_reportDocument.getRecordParser().getFieldNames(), false);
            }
            if (bl2) {
                this.m_reportDocument.insertDatabaseDatatoReportDocument(xMultiServiceFactory);
            }
            if (this.CurReportFinalizer.getReportOpenMode() == 1) {
                bl = this.m_reportDocument.getRecordParser().storeDatabaseDocumentToTempPath(this.m_reportDocument.getComponent(), this.CurReportFinalizer.getStoreName());
            }
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
        dataimport.xComponent.dispose();
        if (bl) {
            this.m_reportDocument.getRecordParser().addReportDocument(this.m_reportDocument.getComponent(), false);
        }
        this.m_reportDocument.getRecordParser().dispose();
    }

    private boolean getReportResources(boolean bl) {
        sMsgWizardName = this.m_oResource.getResText("RID_REPORT_0");
        if (!bl) {
            sShowBinaryFields = this.m_oResource.getResText("RID_REPORT_60");
            slblTables = this.m_oResource.getResText("RID_FORM_6");
            slblFields = this.m_oResource.getResText("RID_FORM_12");
            slblSelFields = this.m_oResource.getResText("RID_REPORT_9");
            this.WizardHeaderText[0] = this.m_oResource.getResText("RID_REPORT_28");
            this.WizardHeaderText[1] = this.m_oResource.getResText("RID_REPORT_69");
            this.WizardHeaderText[2] = this.m_oResource.getResText("RID_REPORT_29");
            this.WizardHeaderText[3] = this.m_oResource.getResText("RID_REPORT_30");
            this.WizardHeaderText[4] = this.m_oResource.getResText("RID_REPORT_31");
            this.WizardHeaderText[5] = this.m_oResource.getResText("RID_REPORT_32");
        }
        slblColumnTitles = this.m_oResource.getResText("RID_REPORT_70");
        slblColumnNames = this.m_oResource.getResText("RID_REPORT_71");
        return true;
    }

    public static String getBlindTextNote(Object object, Resource resource) {
        String string = PropertyNames.EMPTY_STRING;
        if (object instanceof ReportTextImplementation) {
            string = resource.getResText("RID_REPORT_75");
            string = JavaTools.replaceSubString(string, String.valueOf('\r'), "<BR>");
        }
        return string;
    }

    private void enableRoadmapItems(boolean bl) {
        try {
            Object object = null;
            int n = AnyConverter.toInt((Object)Helper.getUnoPropertyValue(this.xDialogModel, PropertyNames.PROPERTY_STEP));
            boolean bl2 = false;
            for (int i = 0; i < this.getRMItemCount(); ++i) {
                object = this.xIndexContRoadmap.getByIndex(i);
                int n2 = AnyConverter.toInt((Object)Helper.getUnoPropertyValue(object, "ID"));
                bl2 = n2 > n ? bl : true;
                Helper.setUnoPropertyValue(object, PropertyNames.PROPERTY_ENABLED, bl2);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private void enableWizardSteps(String[] stringArray) {
        boolean bl = stringArray.length > 0;
        this.setControlProperty("btnWizardNext", PropertyNames.PROPERTY_ENABLED, bl);
        this.setControlProperty("btnWizardFinish", PropertyNames.PROPERTY_ENABLED, bl);
        this.enableRoadmapItems(bl);
    }

    public void textChanged(TextEvent textEvent) {
        try {
            Object object = UnoDialog.getModel(textEvent.Source);
            String string = (String)Helper.getUnoPropertyValue(object, "Text");
            String string2 = this.CurTitlesComponent.getFieldNameByTitleControl(object);
            this.m_reportDocument.liveupdate_changeUserFieldContent(string2, string);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void disposing(EventObject eventObject) {
    }

    private void toggleSortingPage() {
        boolean bl;
        int n = this.CurDBCommandFieldSelection.getSelectedCommandType();
        boolean bl2 = bl = n == 0;
        if (!bl) {
            String string = this.CurDBCommandFieldSelection.getSelectedCommandName();
            DBMetaData.CommandObject commandObject = this.m_reportDocument.getRecordParser().getQueryByName(string);
            bl = this.m_reportDocument.getRecordParser().hasEscapeProcessing(commandObject.getPropertySet());
        }
        super.setStepEnabled(4, bl);
    }

    private class FieldSelectionListener
    implements XFieldSelectionListener {
        private int m_nID;

        private FieldSelectionListener() {
        }

        public void setID(String string) {
            this.m_nID = 1;
            if (string != null && !string.equals(PropertyNames.EMPTY_STRING) && !string.equals("_")) {
                String string2 = JavaTools.ArrayoutofString(string, "_")[1];
                this.m_nID = Integer.parseInt(string2);
            }
        }

        public void shiftFromLeftToRight(String[] stringArray, String[] stringArray2) {
            if (this.m_nID == 1) {
                ReportWizard.this.CurDBCommandFieldSelection.setModified(true);
                ReportWizard.this.enableWizardSteps(stringArray2);
                ReportWizard.this.toggleSortingPage();
            }
        }

        public void shiftFromRightToLeft(String[] stringArray, String[] stringArray2) {
            if (this.m_nID == 1) {
                ReportWizard.this.enableWizardSteps(stringArray2);
                ReportWizard.this.CurDBCommandFieldSelection.setModified(true);
            }
        }

        public void moveItemDown(String string) {
        }

        public void moveItemUp(String string) {
        }
    }
}

