/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets;

import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetListener;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.tools.Logging;

public final class TaggingPresetNameTemplateList
implements TaggingPresetListener {
    private static TaggingPresetNameTemplateList instance;
    private final List<TaggingPreset> presetsWithPattern = new LinkedList<TaggingPreset>();

    public static synchronized TaggingPresetNameTemplateList getInstance() {
        if (instance == null) {
            instance = new TaggingPresetNameTemplateList();
            TaggingPresets.addListener(instance);
        }
        return instance;
    }

    private TaggingPresetNameTemplateList() {
        this.buildPresetsWithPattern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildPresetsWithPattern() {
        TaggingPresetNameTemplateList taggingPresetNameTemplateList = this;
        synchronized (taggingPresetNameTemplateList) {
            Logging.debug("Building list of presets with name template");
            this.presetsWithPattern.clear();
            for (TaggingPreset tp : TaggingPresets.getTaggingPresets()) {
                if (tp.nameTemplate == null) continue;
                this.presetsWithPattern.add(tp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaggingPreset findPresetTemplate(OsmPrimitive primitive) {
        TaggingPresetNameTemplateList taggingPresetNameTemplateList = this;
        synchronized (taggingPresetNameTemplateList) {
            for (TaggingPreset t : this.presetsWithPattern) {
                EnumSet<TaggingPresetType> type;
                if (!t.typeMatches(type = EnumSet.of(TaggingPresetType.forPrimitive(primitive)))) continue;
                if (t.nameTemplateFilter != null) {
                    if (!t.nameTemplateFilter.match(primitive)) continue;
                    return t;
                }
                if (!t.matches(type, primitive.getKeys(), false)) continue;
                return t;
            }
        }
        return null;
    }

    @Override
    public void taggingPresetsModified() {
        this.buildPresetsWithPattern();
    }
}

