/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.windows.x86;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCFrame;
import sun.jvm.hotspot.debugger.windbg.WindbgDebugger;
import sun.jvm.hotspot.debugger.x86.X86ThreadContext;

public class WindowsX86CFrame
extends BasicCFrame {
    private Address ebp;
    private Address pc;
    private static final int ADDRESS_SIZE = 4;
    private WindbgDebugger dbg;

    public WindowsX86CFrame(WindbgDebugger dbg, Address ebp, Address pc) {
        super(dbg.getCDebugger());
        this.ebp = ebp;
        this.pc = pc;
        this.dbg = dbg;
    }

    @Override
    public CFrame sender(ThreadProxy thread) {
        X86ThreadContext context = (X86ThreadContext)thread.getContext();
        Address esp = context.getRegisterAsAddress(7);
        if (this.ebp == null || this.ebp.lessThan(esp)) {
            return null;
        }
        if (this.dbg.getAddressValue(this.ebp) % 4L != 0L) {
            return null;
        }
        Address nextEBP = this.ebp.getAddressAt(0L);
        if (nextEBP == null || nextEBP.lessThanOrEqual(this.ebp)) {
            return null;
        }
        Address nextPC = this.ebp.getAddressAt(4L);
        if (nextPC == null) {
            return null;
        }
        return new WindowsX86CFrame(this.dbg, nextEBP, nextPC);
    }

    @Override
    public Address pc() {
        return this.pc;
    }

    @Override
    public Address localVariableBase() {
        return this.ebp;
    }
}

