/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.print;

import gnu.javax.print.CupsServer;
import gnu.javax.print.ipp.IppException;
import java.util.ArrayList;
import javax.print.DocFlavor;
import javax.print.MultiDocPrintService;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;

public class CupsPrintServiceLookup
extends PrintServiceLookup {
    private CupsServer server;

    public CupsPrintServiceLookup() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPrintJobAccess();
        }
        this.server = new CupsServer(null, null);
    }

    public PrintService getDefaultPrintService() {
        try {
            return this.server.getDefaultPrinter();
        }
        catch (IppException ippException) {
            return null;
        }
    }

    public MultiDocPrintService[] getMultiDocPrintServices(DocFlavor[] flavors, AttributeSet attributes) {
        ArrayList<PrintService> result = new ArrayList<PrintService>();
        PrintService[] services = this.getPrintServices();
        int i = 0;
        while (i < services.length) {
            if (this.checkMultiDocPrintService(flavors, attributes, services[i])) {
                result.add(services[i]);
            }
            ++i;
        }
        return result.toArray(new MultiDocPrintService[result.size()]);
    }

    public PrintService[] getPrintServices() {
        ArrayList result = new ArrayList();
        try {
            result.addAll(this.server.getAllPrinters());
            result.addAll(this.server.getAllClasses());
        }
        catch (IppException ippException) {}
        return result.toArray(new PrintService[result.size()]);
    }

    public PrintService[] getPrintServices(DocFlavor flavor, AttributeSet attributes) {
        ArrayList<PrintService> result = new ArrayList<PrintService>();
        PrintService[] services = this.getPrintServices();
        int i = 0;
        while (i < services.length) {
            if (this.checkPrintService(flavor, attributes, services[i])) {
                result.add(services[i]);
            }
            ++i;
        }
        return result.toArray(new PrintService[result.size()]);
    }

    public boolean checkPrintService(DocFlavor flavor, AttributeSet attributes, PrintService service) {
        boolean allAttributesSupported = true;
        if (flavor == null || service.isDocFlavorSupported(flavor)) {
            if (attributes == null || attributes.size() == 0) {
                return allAttributesSupported;
            }
            Attribute[] atts = attributes.toArray();
            int i = 0;
            while (i < atts.length) {
                if (!service.isAttributeCategorySupported(atts[i].getCategory())) {
                    allAttributesSupported = false;
                    break;
                }
                ++i;
            }
            return allAttributesSupported;
        }
        return false;
    }

    public boolean checkMultiDocPrintService(DocFlavor[] flavors, AttributeSet attributes, PrintService service) {
        if (service instanceof MultiDocPrintService) {
            boolean allFlavorsSupported = true;
            boolean allAttributesSupported = true;
            if (flavors == null || flavors.length != 0) {
                allFlavorsSupported = true;
            } else {
                int k = 0;
                while (k < flavors.length) {
                    if (!service.isDocFlavorSupported(flavors[k])) {
                        allFlavorsSupported = false;
                        break;
                    }
                    ++k;
                }
            }
            if (attributes == null || attributes.size() == 0) {
                allAttributesSupported = true;
            } else {
                Attribute[] atts = attributes.toArray();
                int j = 0;
                while (j < atts.length) {
                    if (!service.isAttributeCategorySupported(atts[j].getCategory())) {
                        allAttributesSupported = false;
                        break;
                    }
                    ++j;
                }
            }
            if (allAttributesSupported && allFlavorsSupported) {
                return true;
            }
        }
        return false;
    }
}

