/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.cubeinput;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.cubeinput.CubeInput;
import org.pentaho.di.trans.steps.cubeinput.CubeInputData;
import org.pentaho.di.trans.steps.cubeinput.Messages;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Step(name={"CubeInput"}, image="ui/images/CIP.png", tooltip="BaseStep.TypeTooltipDesc.Cubeinput", description="BaseStep.TypeLongDesc.CubeInput", category=0)
public class CubeInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String filename;
    private int rowLimit;
    private boolean addfilenameresult;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public boolean isAddResultFile() {
        return this.addfilenameresult;
    }

    public void setAddResultFile(boolean addfilenameresult) {
        this.addfilenameresult = addfilenameresult;
    }

    @Override
    public Object clone() {
        CubeInputMeta retval = (CubeInputMeta)super.clone();
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.filename = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"name");
            this.rowLimit = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"limit"), (int)0);
            this.addfilenameresult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"addfilenameresult"));
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("CubeInputMeta.Exception.UnableToLoadStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.filename = "file";
        this.rowLimit = 0;
        this.addfilenameresult = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        FilterInputStream dis;
        GZIPInputStream fis;
        block15: {
            block14: {
                fis = null;
                dis = null;
                try {
                    try {
                        InputStream is = KettleVFS.getInputStream((String)space.environmentSubstitute(this.filename));
                        fis = new GZIPInputStream(is);
                        dis = new DataInputStream(fis);
                        RowMeta add = new RowMeta((DataInputStream)dis);
                        if (add == null) {
                            Object var12_12 = null;
                            break block14;
                        }
                        for (int i = 0; i < add.size(); ++i) {
                            add.getValueMeta(i).setOrigin(name);
                        }
                        r.mergeRowMeta((RowMetaInterface)add);
                        break block15;
                    }
                    catch (KettleFileException kfe) {
                        throw new KettleStepException(Messages.getString("CubeInputMeta.Exception.UnableToReadMetaData"), (Throwable)kfe);
                    }
                    catch (IOException e) {
                        throw new KettleStepException(Messages.getString("CubeInputMeta.Exception.ErrorOpeningOrReadingCubeFile"), (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        if (dis == null) throw throwable;
                        dis.close();
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        throw new KettleStepException(Messages.getString("CubeInputMeta.Exception.UnableToCloseCubeFile"), (Throwable)ioe);
                    }
                }
            }
            try {}
            catch (IOException ioe) {
                throw new KettleStepException(Messages.getString("CubeInputMeta.Exception.UnableToCloseCubeFile"), (Throwable)ioe);
            }
            if (fis != null) {
                fis.close();
            }
            if (dis == null) return;
            dis.close();
            return;
        }
        Object var12_13 = null;
        try {}
        catch (IOException ioe) {
            throw new KettleStepException(Messages.getString("CubeInputMeta.Exception.UnableToCloseCubeFile"), (Throwable)ioe);
        }
        if (fis != null) {
            fis.close();
        }
        if (dis == null) return;
        dis.close();
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("    <file>").append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.filename));
        retval.append("    </file>").append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"limit", (int)this.rowLimit));
        retval.append("    ").append(XMLHandler.addTagValue((String)"addfilenameresult", (boolean)this.addfilenameresult));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.filename = rep.getStepAttributeString(id_step, "file_name");
            this.rowLimit = (int)rep.getStepAttributeInteger(id_step, "limit");
            this.addfilenameresult = rep.getStepAttributeBoolean(id_step, "addfilenameresult");
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("CubeInputMeta.Exception.UnexpectedErrorWhileReadingStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "file_name", this.filename);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            rep.saveStepAttribute(id_transformation, id_step, "addfilenameresult", this.addfilenameresult);
        }
        catch (KettleException e) {
            throw new KettleException(Messages.getString("CubeInputMeta.Exception.UnableToSaveStepInfo") + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transmeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr = new CheckResult(2, Messages.getString("CubeInputMeta.CheckResult.FileSpecificationsNotChecked"), (CheckResultSourceInterface)stepinfo);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new CubeInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new CubeInputData();
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository) throws KettleException {
        try {
            FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.filename));
            if (fileObject.exists()) {
                this.filename = resourceNamingInterface.nameResource(fileObject.getName().getBaseName(), fileObject.getParent().getName().getPath(), space.toString(), ResourceNamingInterface.FileNamingType.DATA_FILE);
                return this.filename;
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

