/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.url;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.linkedin.util.text.TextUtils;

public class URLCodec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final URLCodec INSTANCE = new URLCodec(false);
    public static final String CHARACTER_ENCODING = "UTF-8";
    private final boolean _encodeDot;
    private final String _characterEncoding;

    public static URLCodec instance() {
        return INSTANCE;
    }

    public URLCodec(boolean encodeDot, String characterEncoding) throws UnsupportedEncodingException {
        this._encodeDot = encodeDot;
        "".getBytes(characterEncoding);
        this._characterEncoding = characterEncoding;
    }

    public URLCodec(boolean encodeDot) {
        this._encodeDot = encodeDot;
        this._characterEncoding = CHARACTER_ENCODING;
    }

    public URLCodec() {
        this(false);
    }

    public String getCharacterEncoding() {
        return this._characterEncoding;
    }

    public boolean isEncodeDot() {
        return this._encodeDot;
    }

    public String urlEncode(String original) {
        String s = null;
        try {
            s = URLEncoder.encode(original, this._characterEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (this._encodeDot) {
            s = TextUtils.searchAndReplace(s, ".", "%2E");
        }
        return s;
    }

    public String urlDecode(String original) {
        try {
            return URLDecoder.decode(original, this._characterEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        URLCodec urlCodec = (URLCodec)o;
        if (this._encodeDot != urlCodec._encodeDot) {
            return false;
        }
        return !(this._characterEncoding != null ? !this._characterEncoding.equals(urlCodec._characterEncoding) : urlCodec._characterEncoding != null);
    }

    public int hashCode() {
        int result = this._encodeDot ? 1 : 0;
        result = 31 * result + (this._characterEncoding != null ? this._characterEncoding.hashCode() : 0);
        return result;
    }
}

