# Edit Shared Folder Settings of a Guest
use strict;
use warnings;
our (%gui, %vmc);

sub setup_edit_dialog_shared {
    &addrow_log("Fetching shared folder settings for $vmc{Name}...");
    &busy_pointer($gui{dialogEdit}, 1);
    # Ie only permanent shares
    if ($vmc{SessionType} eq 'WriteLock') {
        $gui{checkbuttonSharedFolderPermanent}->set_active(1);
        $gui{checkbuttonSharedFolderPermanent}->hide();
    }
    else {
        $gui{checkbuttonSharedFolderPermanent}->set_active(0);
        $gui{checkbuttonSharedFolderPermanent}->show();
    }

    &fill_list_editshared($vmc{IMachine});
    &busy_pointer($gui{dialogEdit}, 0);
    &addrow_log('Shared folder settings complete.');
}

# Show the dialog for adding a shared folder
sub show_dialog_shared {
    my ($widget) = @_;

    if ($widget eq $gui{buttonEditSharedEdit}) {
        my $sref = &getsel_list_editshared();
        $gui{entrySharedFolderPath}->set_text($$sref{Folder});
        $gui{entrySharedFolderName}->set_text($$sref{Name});

        if ($$sref{Access} eq 'Read-Only') { $gui{checkbuttonSharedFolderRO}->set_active(1); }
        else { $gui{checkbuttonSharedFolderRO}->set_active(0); }

        if ($$sref{Mount} eq 'Yes') { $gui{checkbuttonSharedFolderMount}->set_active(1); }
        else { $gui{checkbuttonSharedFolderMount}->set_active(0); }
    }

    do {
        my $response = $gui{dialogShared}->run;
        
        if ($response eq 'ok') {
            # No validation needed for other entries
            if (!$gui{entrySharedFolderPath}->get_text()) { &show_err_msg('invalidpath', '(Folder Path)'); }
            elsif (!$gui{entrySharedFolderName}->get_text()) { &show_err_msg('invalidname', '(Folder Name)'); }
            else {
                $gui{dialogShared}->hide;
                &share_remove($widget, $gui{treeviewEditShared}) if ($widget eq $gui{buttonEditSharedEdit});

                if ($gui{checkbuttonSharedFolderPermanent}->get_active()) {
                    IMachine_createSharedFolder($vmc{IMachine}, $gui{entrySharedFolderName}->get_text(),
                                                                $gui{entrySharedFolderPath}->get_text(),
                                                                !$gui{checkbuttonSharedFolderRO}->get_active(),
                                                                $gui{checkbuttonSharedFolderMount}->get_active());
                }
                else {
                    my $sref = &get_session($vmc{IMachine});
                    my $IConsole = ISession_getConsole($$sref{ISession});
                    IConsole_createSharedFolder($IConsole, $gui{entrySharedFolderName}->get_text(),
                                                           $gui{entrySharedFolderPath}->get_text(),
                                                           !$gui{checkbuttonSharedFolderRO}->get_active(),
                                                           $gui{checkbuttonSharedFolderMount}->get_active()) if ($IConsole);
                }

                &fill_list_editshared($vmc{IMachine});
            }
        }
        else { $gui{dialogShared}->hide; }

    } until (!$gui{dialogShared}->visible());
}

# Deletes a share and handles both permanent and transient
sub share_remove {
    my $shareref = &getsel_list_editshared();

    if ($$shareref{Permanent} eq 'Yes') { IMachine_removeSharedFolder($vmc{IMachine}, $$shareref{Name}); }
    else {
        my $sref = &get_session($vmc{IMachine});
        my $IConsole = ISession_getConsole($$sref{ISession});
        IConsole_removeSharedFolder($IConsole, $$shareref{Name}) if ($IConsole);
    }

    &fill_list_editshared($vmc{IMachine});
}

1;