/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.report;

import java.io.File;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.extension.ExtensionLoader;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.extension.report.ReportGenerator;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.XmlReporterExtension;
import org.zaproxy.zap.utils.DesktopUtils;
import org.zaproxy.zap.utils.XMLStringUtil;
import org.zaproxy.zap.view.ScanPanel;
import org.zaproxy.zap.view.widgets.WritableFileChooser;

public class ReportLastScan {
    private Logger logger = Logger.getLogger(ReportLastScan.class);
    private static final String HTM_FILE_EXTENSION = ".htm";
    private static final String HTML_FILE_EXTENSION = ".html";
    private static final String XML_FILE_EXTENSION = ".xml";
    private static final String MD_FILE_EXTENSION = ".md";
    private static final String JSON_FILE_EXTENSION = ".json";

    @Deprecated
    public File generate(String fileName, Model model, String xslFile) throws Exception {
        StringBuilder sb = new StringBuilder(500);
        this.generate(sb, model);
        return ReportGenerator.stringToHtml(sb.toString(), xslFile, fileName);
    }

    public File generate(String fileName, Model model, ReportType reportType) throws Exception {
        String xslFile = "";
        switch (reportType) {
            case XML: 
            case JSON: {
                xslFile = null;
                break;
            }
            case MD: {
                xslFile = Constant.getZapInstall() + "/xml/report.md.xsl";
                break;
            }
            default: {
                xslFile = Constant.getZapInstall() + "/xml/report.html.xsl";
            }
        }
        StringBuilder sb = new StringBuilder(500);
        this.generate(sb, model);
        if (reportType == ReportType.JSON) {
            return ReportGenerator.stringToJson(sb.toString(), fileName);
        }
        return ReportGenerator.stringToHtml(sb.toString(), xslFile, fileName);
    }

    public void generate(StringBuilder report, Model model) throws Exception {
        report.append("<?xml version=\"1.0\"?>");
        report.append("<OWASPZAPReport version=\"").append(Constant.PROGRAM_VERSION).append("\" generated=\"").append(ReportGenerator.getCurrentDateTimeString()).append("\">\r\n");
        this.siteXML(report);
        report.append("</OWASPZAPReport>");
    }

    private void siteXML(StringBuilder report) {
        SiteMap siteMap = Model.getSingleton().getSession().getSiteTree();
        SiteNode root = (SiteNode)siteMap.getRoot();
        int siteNumber = root.getChildCount();
        for (int i = 0; i < siteNumber; ++i) {
            SiteNode site = (SiteNode)root.getChildAt(i);
            String siteName = ScanPanel.cleanSiteName(site, true);
            String[] hostAndPort = siteName.split(":");
            boolean isSSL = site.getNodeName().startsWith("https");
            String siteStart = "<site name=\"" + XMLStringUtil.escapeControlChrs(site.getNodeName()) + "\" host=\"" + XMLStringUtil.escapeControlChrs(hostAndPort[0]) + "\" port=\"" + XMLStringUtil.escapeControlChrs(hostAndPort[1]) + "\" ssl=\"" + String.valueOf(isSSL) + "\">";
            StringBuilder extensionsXML = this.getExtensionsXML(site);
            String siteEnd = "</site>";
            report.append(siteStart);
            report.append((CharSequence)extensionsXML);
            report.append(siteEnd);
        }
    }

    public StringBuilder getExtensionsXML(SiteNode site) {
        StringBuilder extensionXml = new StringBuilder();
        ExtensionLoader loader = Control.getSingleton().getExtensionLoader();
        int extensionCount = loader.getExtensionCount();
        for (int i = 0; i < extensionCount; ++i) {
            Extension extension = loader.getExtension(i);
            if (!(extension instanceof XmlReporterExtension)) continue;
            extensionXml.append(((XmlReporterExtension)((Object)extension)).getXml(site));
        }
        return extensionXml;
    }

    public void generateReport(ViewDelegate view, Model model, ReportType reportType) {
        final ReportType localReportType = reportType == null ? ReportType.HTML : reportType;
        try {
            WritableFileChooser chooser = new WritableFileChooser(Model.getSingleton().getOptionsParam().getUserDirectory());
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    if (file.isFile()) {
                        String lcFileName = file.getName().toLowerCase(Locale.ROOT);
                        switch (localReportType) {
                            case XML: {
                                return lcFileName.endsWith(ReportLastScan.XML_FILE_EXTENSION);
                            }
                            case MD: {
                                return lcFileName.endsWith(ReportLastScan.MD_FILE_EXTENSION);
                            }
                            case JSON: {
                                return lcFileName.endsWith(ReportLastScan.JSON_FILE_EXTENSION);
                            }
                        }
                        return lcFileName.endsWith(ReportLastScan.HTM_FILE_EXTENSION) || lcFileName.endsWith(ReportLastScan.HTML_FILE_EXTENSION);
                    }
                    return false;
                }

                @Override
                public String getDescription() {
                    switch (localReportType) {
                        case XML: {
                            return Constant.messages.getString("file.format.xml");
                        }
                        case MD: {
                            return Constant.messages.getString("file.format.md");
                        }
                        case JSON: {
                            return Constant.messages.getString("file.format.json");
                        }
                    }
                    return Constant.messages.getString("file.format.html");
                }
            });
            String fileExtension = "";
            switch (localReportType) {
                case XML: {
                    fileExtension = XML_FILE_EXTENSION;
                    break;
                }
                case JSON: {
                    fileExtension = JSON_FILE_EXTENSION;
                    break;
                }
                case MD: {
                    fileExtension = MD_FILE_EXTENSION;
                    break;
                }
                default: {
                    fileExtension = HTML_FILE_EXTENSION;
                }
            }
            chooser.setSelectedFile(new File(fileExtension));
            int rc = chooser.showSaveDialog(View.getSingleton().getMainFrame());
            File file = null;
            if (rc == 0) {
                file = chooser.getSelectedFile();
                File report = this.generate(file.getAbsolutePath(), model, localReportType);
                if (report == null) {
                    view.showMessageDialog(Constant.messages.getString("report.unknown.error", file.getAbsolutePath()));
                    return;
                }
                try {
                    DesktopUtils.openUrlInBrowser(report.toURI());
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                    view.showMessageDialog(Constant.messages.getString("report.complete.warning", report.getAbsolutePath()));
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            view.showWarningDialog(Constant.messages.getString("report.unexpected.error"));
        }
    }

    @Deprecated
    public void generateHtml(ViewDelegate view, Model model) {
        this.generateReport(view, model, ReportType.HTML);
    }

    @Deprecated
    public void generateXml(ViewDelegate view, Model model) {
        this.generateReport(view, model, ReportType.XML);
    }

    public static enum ReportType {
        HTML,
        XML,
        MD,
        JSON;

    }
}

