/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.StringArrayFS;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CommonArrayFSImpl;
import org.apache.uima.cas.impl.FSGenerator;

public class StringArrayFSImpl
extends CommonArrayFSImpl
implements StringArrayFS {
    public StringArrayFSImpl(int addr, CASImpl cas) {
        super(cas, addr);
    }

    static FSGenerator generator() {
        return new StringArrayGenerator();
    }

    public int size() {
        return this.casImpl.ll_getArraySize(this.addr);
    }

    public String get(int i) {
        if (i < 0 || i >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.casImpl.getStringForCode(this.casImpl.getArrayValue(this.addr, i));
    }

    public void set(int i, String str) throws ArrayIndexOutOfBoundsException {
        this.casImpl.setArrayValue(this.addr, i, this.casImpl.addString(str));
    }

    public void copyFromArray(String[] src, int srcOffset, int destOffset, int length) throws ArrayIndexOutOfBoundsException {
        if (destOffset < 0 || destOffset + length > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        destOffset += this.casImpl.getArrayStartAddress(this.addr);
        for (int i = 0; i < length; ++i) {
            this.casImpl.getHeap().heap[destOffset] = this.casImpl.addString(src[srcOffset]);
            ++destOffset;
            ++srcOffset;
        }
    }

    public void copyToArray(int srcOffset, String[] dest, int destOffset, int length) throws ArrayIndexOutOfBoundsException {
        if (srcOffset < 0 || srcOffset + length > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = 0; i < length; ++i) {
            dest[destOffset] = this.casImpl.ll_getStringArrayValue(this.addr, srcOffset);
            ++destOffset;
            ++srcOffset;
        }
    }

    public String[] toArray() {
        int size = this.size();
        String[] outArray = new String[size];
        this.copyToArray(0, outArray, 0, size);
        return outArray;
    }

    private static class StringArrayGenerator
    implements FSGenerator {
        private StringArrayGenerator() {
        }

        public FeatureStructure createFS(int addr, CASImpl cas) {
            return new StringArrayFSImpl(addr, cas);
        }
    }
}

