/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.analysis_engine.metadata.CapabilityLanguageFlow;
import org.apache.uima.analysis_engine.metadata.FixedFlow;
import org.apache.uima.analysis_engine.metadata.FlowConstraints;
import org.apache.uima.analysis_engine.metadata.FlowControllerDeclaration;
import org.apache.uima.analysis_engine.metadata.SofaMapping;
import org.apache.uima.analysis_engine.metadata.impl.AnalysisEngineMetaData_impl;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.impl.ResourceCreationSpecifier_impl;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.MetaDataObject;
import org.apache.uima.resource.metadata.OperationalProperties;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.Level;
import org.apache.uima.util.NameClassPair;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisEngineDescription_impl
extends ResourceCreationSpecifier_impl
implements AnalysisEngineDescription {
    private static final String LOG_RESOURCE_BUNDLE = "org.apache.uima.impl.log_messages";
    protected String PROP_DELEGATE_ANALYSIS_ENGINE_SPECIFIERS = "delegateAnalysisEngineSpecifiers";
    protected String PROP_DELEGATE_ANALYSIS_ENGINE_SPECIFIERS_WITH_IMPORTS = "delegateAnalysisEngineSpecifiersWithImports";
    protected String ELEM_DELEGATE_ANALYSIS_ENGINE_SPECIFIERS = "delegateAnalysisEngineSpecifiers";
    private String mFrameworkImplementation;
    private boolean mPrimitive;
    private FlowControllerDeclaration mFlowControllerDeclaration;
    private Map<String, ResourceSpecifier> mDelegateAnalysisEngineSpecifiers = new HashMap<String, ResourceSpecifier>();
    private Map<String, MetaDataObject> mDelegateAnalysisEngineSpecifiersWithImports = new HashMap<String, MetaDataObject>();
    private Map<String, Import> mProcessedImports = new HashMap<String, Import>();
    private SofaMapping[] mSofaMappings;
    static final long serialVersionUID = -8103625125291855592L;
    private static final XmlizationInfo XMLIZATION_INFO = new XmlizationInfo("analysisEngineDescription", new PropertyXmlInfo[]{new PropertyXmlInfo("frameworkImplementation"), new PropertyXmlInfo("primitive"), new PropertyXmlInfo("annotatorImplementationName"), new PropertyXmlInfo("delegateAnalysisEngineSpecifiersWithImports", "delegateAnalysisEngineSpecifiers"), new PropertyXmlInfo("flowControllerDeclaration", null), new PropertyXmlInfo("metaData", null), new PropertyXmlInfo("externalResourceDependencies"), new PropertyXmlInfo("resourceManagerConfiguration", null), new PropertyXmlInfo("sofaMappings")});

    public AnalysisEngineDescription_impl() {
        this.setMetaData(new AnalysisEngineMetaData_impl());
        this.setFrameworkImplementation("org.apache.uima.java");
        OperationalProperties opProps = UIMAFramework.getResourceSpecifierFactory().createOperationalProperties();
        opProps.setModifiesCas(true);
        opProps.setMultipleDeploymentAllowed(true);
        opProps.setOutputsNewCASes(false);
        this.getAnalysisEngineMetaData().setOperationalProperties(opProps);
    }

    @Override
    public String getFrameworkImplementation() {
        return this.mFrameworkImplementation;
    }

    @Override
    public void setFrameworkImplementation(String aFrameworkImplementation) {
        this.mFrameworkImplementation = aFrameworkImplementation;
    }

    @Override
    public boolean isPrimitive() {
        return this.mPrimitive;
    }

    @Override
    public void setPrimitive(boolean aPrimitive) {
        this.mPrimitive = aPrimitive;
    }

    @Override
    public String getAnnotatorImplementationName() {
        return this.getImplementationName();
    }

    @Override
    public void setAnnotatorImplementationName(String aImplementationName) {
        this.setImplementationName(aImplementationName);
    }

    @Override
    public Map<String, ResourceSpecifier> getDelegateAnalysisEngineSpecifiers() throws InvalidXMLException {
        this.resolveDelegateAnalysisEngineImports(UIMAFramework.newDefaultResourceManager(), false);
        return Collections.unmodifiableMap(this.mDelegateAnalysisEngineSpecifiers);
    }

    @Override
    public Map<String, ResourceSpecifier> getDelegateAnalysisEngineSpecifiers(ResourceManager aResourceManager) throws InvalidXMLException {
        this.resolveDelegateAnalysisEngineImports(aResourceManager, false);
        return Collections.unmodifiableMap(this.mDelegateAnalysisEngineSpecifiers);
    }

    @Override
    public Map<String, MetaDataObject> getDelegateAnalysisEngineSpecifiersWithImports() {
        return this.mDelegateAnalysisEngineSpecifiersWithImports;
    }

    @Override
    public FlowControllerDeclaration getFlowControllerDeclaration() {
        return this.mFlowControllerDeclaration;
    }

    @Override
    public void setFlowControllerDeclaration(FlowControllerDeclaration aFlowControllerDeclaration) {
        this.mFlowControllerDeclaration = aFlowControllerDeclaration;
    }

    @Override
    public Map<String, ResourceSpecifier> getAllComponentSpecifiers(ResourceManager aResourceManager) throws InvalidXMLException {
        if (aResourceManager == null) {
            aResourceManager = UIMAFramework.newDefaultResourceManager();
        }
        this.resolveImports(aResourceManager);
        HashMap<String, ResourceSpecifier> map = new HashMap<String, ResourceSpecifier>(this.mDelegateAnalysisEngineSpecifiers);
        if (this.getFlowControllerDeclaration() != null) {
            map.put(this.getFlowControllerDeclaration().getKey(), this.getFlowControllerDeclaration().getSpecifier());
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public AnalysisEngineMetaData getAnalysisEngineMetaData() {
        return (AnalysisEngineMetaData)this.getMetaData();
    }

    @Override
    public SofaMapping[] getSofaMappings() {
        return this.mSofaMappings;
    }

    @Override
    public void setSofaMappings(SofaMapping[] aSofaMappings) {
        this.mSofaMappings = aSofaMappings;
    }

    @Override
    public void doFullValidation() throws ResourceInitializationException {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("VERIFICATION_MODE", Boolean.TRUE);
        AnalysisEngine ae = UIMAFramework.produceAnalysisEngine(this, m);
        this.validateSofaMappings();
        ae.newCAS();
    }

    @Override
    public void doFullValidation(ResourceManager aResourceManager) throws ResourceInitializationException {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("VERIFICATION_MODE", Boolean.TRUE);
        AnalysisEngine ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)this, aResourceManager, m);
        this.validateSofaMappings();
        ae.newCAS();
    }

    @Override
    public void validate(ResourceManager aResourceManager) throws ResourceInitializationException, ResourceConfigurationException {
        super.validate(aResourceManager);
        if (!this.isPrimitive() && this.getAnalysisEngineMetaData().getTypeSystem() != null) {
            throw new ResourceInitializationException("aggregate_ae_type_system", new Object[]{this.getSourceUrlString()});
        }
        FlowConstraints fc = this.getAnalysisEngineMetaData().getFlowConstraints();
        String[] keys = null;
        if (fc instanceof FixedFlow) {
            keys = ((FixedFlow)fc).getFixedFlow();
        } else if (fc instanceof CapabilityLanguageFlow) {
            keys = ((CapabilityLanguageFlow)fc).getCapabilityLanguageFlow();
        }
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                if (this.getDelegateAnalysisEngineSpecifiersWithImports().containsKey(keys[i])) continue;
                throw new ResourceInitializationException("undefined_key_in_flow", new Object[]{this.getAnalysisEngineMetaData().getName(), keys[i], this.getSourceUrlString()});
            }
        }
    }

    @Override
    protected void checkForInvalidParameterOverrides(ConfigurationParameter[] aParams, String aGroupName, ResourceManager aResourceManager) throws ResourceInitializationException {
        try {
            this.resolveImports(aResourceManager);
        }
        catch (InvalidXMLException e) {
            throw new ResourceInitializationException(e);
        }
        for (int i = 0; i < aParams.length; ++i) {
            String[] overrides = aParams[i].getOverrides();
            if (overrides.length > 0 && this.isPrimitive()) {
                throw new ResourceInitializationException("param_override_in_primitive", new Object[]{aParams[i].getName(), this.getMetaData().getName(), this.getSourceUrlString()});
            }
            if (overrides.length == 0 && !this.isPrimitive()) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "checkForInvalidParameterOverrides", LOG_RESOURCE_BUNDLE, "UIMA_aggregate_param_no_overrides__WARNING", new Object[]{this.getMetaData().getName(), aParams[i].getName()});
            }
            for (int j = 0; j < overrides.length; ++j) {
                int slashPos = overrides[j].indexOf(47);
                if (slashPos <= 0 || slashPos >= overrides[j].length()) {
                    throw new ResourceInitializationException("invalid_param_override_syntax", new Object[]{overrides[j], aParams[i].getName(), this.getMetaData().getName(), this.getSourceUrlString()});
                }
                String delegateKey = overrides[j].substring(0, slashPos);
                String paramName = overrides[j].substring(slashPos + 1);
                ResourceSpecifier componentSpecifier = this.getComponentSpecifier(delegateKey);
                if (componentSpecifier == null) {
                    throw new ResourceInitializationException("invalid_param_override_nonexistent_delegate", new Object[]{overrides[j], aParams[i].getName(), this.getMetaData().getName(), delegateKey, this.getSourceUrlString()});
                }
                if (!(componentSpecifier instanceof ResourceCreationSpecifier)) continue;
                ConfigurationParameter overriddenParam = null;
                ConfigurationParameterDeclarations delegateParamDecls = ((ResourceCreationSpecifier)componentSpecifier).getMetaData().getConfigurationParameterDeclarations();
                if (aGroupName == null) {
                    overriddenParam = delegateParamDecls.getConfigurationParameter(null, paramName);
                    if (overriddenParam != null) continue;
                    throw new ResourceInitializationException("invalid_param_override_nonexistent_parameter", new Object[]{overrides[j], aParams[i].getName(), this.getMetaData().getName(), delegateKey, paramName, this.getSourceUrlString()});
                }
                overriddenParam = delegateParamDecls.getConfigurationParameter(aGroupName, paramName);
                if (overriddenParam != null) continue;
                throw new ResourceInitializationException("invalid_param_override_nonexistent_parameter_in_group", new Object[]{overrides[j], aParams[i].getName(), this.getMetaData().getName(), delegateKey, paramName, aGroupName, this.getSourceUrlString()});
            }
        }
    }

    @Override
    public ResourceSpecifier getComponentSpecifier(String key) throws ResourceInitializationException {
        ResourceSpecifier componentSpecifier;
        if (this.getFlowControllerDeclaration() != null && key.equals(this.getFlowControllerDeclaration().getKey())) {
            try {
                this.getFlowControllerDeclaration().resolveImports();
            }
            catch (InvalidXMLException e) {
                throw new ResourceInitializationException(e);
            }
            componentSpecifier = this.getFlowControllerDeclaration().getSpecifier();
        } else {
            try {
                componentSpecifier = this.getDelegateAnalysisEngineSpecifiers().get(key);
            }
            catch (InvalidXMLException e) {
                throw new ResourceInitializationException(e);
            }
        }
        return componentSpecifier;
    }

    protected void validateSofaMappings() throws ResourceInitializationException {
        Iterator<Map.Entry<String, ResourceSpecifier>> iter;
        if (this.isPrimitive()) {
            return;
        }
        String aggName = this.getAnalysisEngineMetaData().getName();
        TreeMap<String, String> sofamap = new TreeMap<String, String>();
        SofaMapping[] sofaMappings = this.getSofaMappings();
        if (sofaMappings != null) {
            for (int s = 0; s < sofaMappings.length; ++s) {
                String componentKey = sofaMappings[s].getComponentKey();
                ResourceSpecifier componentSpec = this.getComponentSpecifier(componentKey);
                if (componentSpec == null) {
                    throw new ResourceInitializationException("sofa_mapping_has_undefined_component_key", new Object[]{componentKey, sofaMappings[s].getAggregateSofaName(), aggName, this.getSourceUrlString()});
                }
                String componentSofaName = sofaMappings[s].getComponentSofaName();
                if (componentSofaName == null) {
                    componentSofaName = "_InitialView";
                } else if (componentSpec instanceof AnalysisEngineDescription && !"_InitialView".equals(componentSofaName) && !this.declaresSofa((AnalysisEngineDescription)componentSpec, componentSofaName)) {
                    throw new ResourceInitializationException("sofa_mapping_has_undefined_component_sofa", new Object[]{componentKey, componentSofaName, sofaMappings[s].getAggregateSofaName(), aggName, this.getSourceUrlString()});
                }
                String compoundKey = sofaMappings[s].getComponentKey() + "@/@" + sofaMappings[s].getComponentSofaName();
                String aggSofaName = sofaMappings[s].getAggregateSofaName();
                String existingMapping = (String)sofamap.get(compoundKey);
                if (existingMapping != null && !existingMapping.equals(aggSofaName)) {
                    throw new ResourceInitializationException("sofa_mapping_conflict", new Object[]{sofaMappings[s].getComponentSofaName(), sofaMappings[s].getComponentKey(), aggName, existingMapping, aggSofaName, this.getSourceUrlString()});
                }
                sofamap.put(compoundKey, aggSofaName);
            }
        }
        boolean containsRemote = false;
        HashSet<String> correctlyMappedAggregateOutputs = new HashSet<String>();
        HashSet<String> correctlyMappedAggregateInputs = new HashSet<String>();
        try {
            iter = this.getDelegateAnalysisEngineSpecifiers().entrySet().iterator();
        }
        catch (InvalidXMLException e) {
            throw new ResourceInitializationException(e);
        }
        while (iter.hasNext()) {
            Map.Entry<String, ResourceSpecifier> entry = iter.next();
            String componentKey = entry.getKey();
            ResourceSpecifier delegateSpec = entry.getValue();
            if (delegateSpec instanceof AnalysisEngineDescription) {
                Capability[] caps = ((AnalysisEngineDescription)delegateSpec).getAnalysisEngineMetaData().getCapabilities();
                for (int i = 0; i < caps.length; ++i) {
                    String[] outputSofas = caps[i].getOutputSofas();
                    for (int j = 0; j < outputSofas.length; ++j) {
                        String aggSofa = (String)sofamap.get(componentKey + "@/@" + outputSofas[j]);
                        if (aggSofa == null) {
                            aggSofa = outputSofas[j];
                        }
                        if (!this.capabilitiesContainSofa(aggSofa, true)) {
                            throw new ResourceInitializationException("output_sofa_not_declared_in_aggregate", new Object[]{outputSofas[j], componentKey, aggName, this.getSourceUrlString()});
                        }
                        correctlyMappedAggregateOutputs.add(aggSofa);
                    }
                    String[] inputSofas = caps[i].getInputSofas();
                    for (int j = 0; j < inputSofas.length; ++j) {
                        String aggSofa = (String)sofamap.get(componentKey + "@/@" + inputSofas[j]);
                        if (aggSofa == null) {
                            aggSofa = inputSofas[j];
                        }
                        if (!this.capabilitiesContainSofa(aggSofa, false) && !this.capabilitiesContainSofa(aggSofa, true)) {
                            throw new ResourceInitializationException("input_sofa_has_no_source", new Object[]{inputSofas[j], componentKey, aggName, this.getSourceUrlString()});
                        }
                        correctlyMappedAggregateInputs.add(aggSofa);
                    }
                    String aggDefSofa = (String)sofamap.get(componentKey + "@/@" + "_InitialView");
                    if (aggDefSofa == null) continue;
                    if (this.capabilitiesContainSofa(aggDefSofa, true)) {
                        correctlyMappedAggregateOutputs.add(aggDefSofa);
                        continue;
                    }
                    correctlyMappedAggregateInputs.add(aggDefSofa);
                }
                continue;
            }
            containsRemote = true;
        }
        if (!containsRemote) {
            Capability[] caps = this.getAnalysisEngineMetaData().getCapabilities();
            for (int i = 0; i < caps.length; ++i) {
                int j;
                String[] sofas = caps[i].getOutputSofas();
                for (j = 0; j < sofas.length; ++j) {
                    if (correctlyMappedAggregateOutputs.contains(sofas[j])) continue;
                    throw new ResourceInitializationException("aggregate_sofa_not_mapped", new Object[]{sofas[j], aggName, this.getSourceUrlString()});
                }
                sofas = caps[i].getInputSofas();
                for (j = 0; j < sofas.length; ++j) {
                    if (correctlyMappedAggregateInputs.contains(sofas[j])) continue;
                    throw new ResourceInitializationException("aggregate_sofa_not_mapped", new Object[]{sofas[j], aggName, this.getSourceUrlString()});
                }
            }
        }
    }

    private boolean declaresSofa(AnalysisEngineDescription aDesc, String aSofaName) {
        Capability[] caps = aDesc.getAnalysisEngineMetaData().getCapabilities();
        for (int i = 0; i < caps.length; ++i) {
            int j;
            String[] sofas = caps[i].getOutputSofas();
            for (j = 0; j < sofas.length; ++j) {
                if (!aSofaName.equals(sofas[j])) continue;
                return true;
            }
            sofas = caps[i].getInputSofas();
            for (j = 0; j < sofas.length; ++j) {
                if (!aSofaName.equals(sofas[j])) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean capabilitiesContainSofa(String aSofaName, boolean aOutput) {
        Capability[] caps = this.getAnalysisEngineMetaData().getCapabilities();
        for (int i = 0; i < caps.length; ++i) {
            String[] sofas = aOutput ? caps[i].getOutputSofas() : caps[i].getInputSofas();
            for (int j = 0; j < sofas.length; ++j) {
                if (!aSofaName.equals(sofas[j])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<NameClassPair> listAttributes() {
        List<NameClassPair> result = super.listAttributes();
        result.add(new NameClassPair(this.PROP_DELEGATE_ANALYSIS_ENGINE_SPECIFIERS_WITH_IMPORTS, Map.class.getName()));
        return result;
    }

    @Override
    public void toXML(OutputStream aOutputStream, boolean aPreserveDelegateAnalysisEngineImports) throws SAXException, IOException {
        if (aPreserveDelegateAnalysisEngineImports) {
            Map<String, ResourceSpecifier> tempMap = this.mDelegateAnalysisEngineSpecifiers;
            this.mDelegateAnalysisEngineSpecifiers = Collections.emptyMap();
            this.toXML(aOutputStream);
            this.mDelegateAnalysisEngineSpecifiers = tempMap;
        } else {
            this.toXML(aOutputStream);
        }
    }

    @Override
    public void toXML(Writer aWriter, boolean aPreserveDelegateAnalysisEngineImports) throws SAXException, IOException {
        if (aPreserveDelegateAnalysisEngineImports) {
            Map<String, ResourceSpecifier> tempMap = this.mDelegateAnalysisEngineSpecifiers;
            this.mDelegateAnalysisEngineSpecifiers = Collections.emptyMap();
            this.toXML(aWriter);
            this.mDelegateAnalysisEngineSpecifiers = tempMap;
        } else {
            this.toXML(aWriter);
        }
    }

    @Override
    public void toXML(ContentHandler aContentHandler, boolean aWriteDefaultNamespaceAttribute, boolean aPreserveDelegateAnalysisEngineImports) throws SAXException {
        if (aPreserveDelegateAnalysisEngineImports) {
            Map<String, ResourceSpecifier> tempMap = this.mDelegateAnalysisEngineSpecifiers;
            this.mDelegateAnalysisEngineSpecifiers = Collections.emptyMap();
            this.toXML(aContentHandler, aWriteDefaultNamespaceAttribute);
            this.mDelegateAnalysisEngineSpecifiers = tempMap;
        } else {
            this.toXML(aContentHandler, aWriteDefaultNamespaceAttribute);
        }
    }

    @Override
    public void resolveImports(ResourceManager aResourceManager) throws InvalidXMLException {
        this.resolveImports(new HashSet<String>(), aResourceManager);
    }

    @Override
    public void resolveImports(Collection<String> aAlreadyImportedDelegateAeUrls, ResourceManager aResourceManager) throws InvalidXMLException {
        if (this.getSourceUrl() != null) {
            aAlreadyImportedDelegateAeUrls.add(this.getSourceUrl().toString());
        }
        this.resolveDelegateAnalysisEngineImports(aAlreadyImportedDelegateAeUrls, aResourceManager, true);
        if (this.getFlowControllerDeclaration() != null) {
            this.getFlowControllerDeclaration().resolveImports(aResourceManager);
        }
        if (this.getAnalysisEngineMetaData() != null) {
            this.getAnalysisEngineMetaData().resolveImports(aResourceManager);
        }
        if (this.getResourceManagerConfiguration() != null) {
            this.getResourceManagerConfiguration().resolveImports(aResourceManager);
        }
    }

    protected void resolveDelegateAnalysisEngineImports(ResourceManager aResourceManager, boolean aRecursive) throws InvalidXMLException {
        HashSet<String> urls = new HashSet<String>();
        if (this.getSourceUrl() != null) {
            urls.add(this.getSourceUrl().toString());
        }
        this.resolveDelegateAnalysisEngineImports(urls, aResourceManager, aRecursive);
    }

    protected void resolveDelegateAnalysisEngineImports(Collection<String> aEnclosingAggregateAeUrls, ResourceManager aResourceManager, boolean aRecursive) throws InvalidXMLException {
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry<String, MetaDataObject> entry : this.getDelegateAnalysisEngineSpecifiersWithImports().entrySet()) {
            String key = entry.getKey();
            keys.add(key);
            if (entry.getValue() instanceof Import) {
                XMLInputSource input;
                URL url;
                Import aeImport = (Import)entry.getValue();
                if (((Object)entry.getValue()).equals(this.mProcessedImports.get(key))) continue;
                if (aeImport instanceof Import_impl) {
                    ((Import_impl)aeImport).setSourceUrlIfNull(this.getSourceUrl());
                }
                if (aEnclosingAggregateAeUrls.contains((url = aeImport.findAbsoluteUrl(aResourceManager)).toString())) {
                    String name = this.getMetaData() == null ? "<null>" : this.getMetaData().getName();
                    throw new InvalidXMLException("circular_ae_import", new Object[]{name, url});
                }
                try {
                    input = new XMLInputSource(url);
                }
                catch (IOException e) {
                    throw new InvalidXMLException("import_failed_could_not_read_from_url", new Object[]{url, aeImport.getSourceUrlString()}, e);
                }
                ResourceSpecifier spec = UIMAFramework.getXMLParser().parseResourceSpecifier(input);
                this.mDelegateAnalysisEngineSpecifiers.put(key, spec);
                this.mProcessedImports.put(key, aeImport);
                if (!(spec instanceof AnalysisEngineDescription)) continue;
                HashSet<String> alreadyImportedUrls = new HashSet<String>(aEnclosingAggregateAeUrls);
                alreadyImportedUrls.add(url.toString());
                ((AnalysisEngineDescription)spec).resolveImports(alreadyImportedUrls, aResourceManager);
                continue;
            }
            this.mDelegateAnalysisEngineSpecifiers.put(entry.getKey(), (ResourceSpecifier)entry.getValue());
            if (!(entry.getValue() instanceof AnalysisEngineDescription)) continue;
            ((AnalysisEngineDescription)entry.getValue()).resolveImports(aEnclosingAggregateAeUrls, aResourceManager);
        }
        ArrayList<String> staleKeys = new ArrayList<String>();
        for (Map.Entry<String, ResourceSpecifier> entry : this.mDelegateAnalysisEngineSpecifiers.entrySet()) {
            String key = entry.getKey();
            if (keys.contains(key)) continue;
            staleKeys.add(key);
        }
        for (String key : staleKeys) {
            this.mDelegateAnalysisEngineSpecifiers.remove(key);
            this.mProcessedImports.remove(key);
        }
    }

    @Override
    protected void writePropertyAsElement(PropertyXmlInfo aPropInfo, String aNamespace, ContentHandler aContentHandler) throws SAXException {
        if (this.PROP_DELEGATE_ANALYSIS_ENGINE_SPECIFIERS_WITH_IMPORTS.equals(aPropInfo.propertyName)) {
            String propName = this.PROP_DELEGATE_ANALYSIS_ENGINE_SPECIFIERS;
            if (this.mDelegateAnalysisEngineSpecifiers.isEmpty()) {
                propName = this.PROP_DELEGATE_ANALYSIS_ENGINE_SPECIFIERS_WITH_IMPORTS;
            }
            this.writeMapPropertyToXml(propName, this.ELEM_DELEGATE_ANALYSIS_ENGINE_SPECIFIERS, "key", "delegateAnalysisEngine", aPropInfo.omitIfNull, aNamespace, aContentHandler);
        } else {
            super.writePropertyAsElement(aPropInfo, aNamespace, aContentHandler);
        }
    }

    @Override
    protected void readPropertyValueFromXMLElement(PropertyXmlInfo aPropXmlInfo, Element aElement, XMLParser aParser, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        String propName = aPropXmlInfo.propertyName;
        if (this.PROP_DELEGATE_ANALYSIS_ENGINE_SPECIFIERS_WITH_IMPORTS.equals(propName)) {
            this.readMapPropertyFromXml(propName, aElement, "key", "delegateAnalysisEngine", aParser, aOptions, false);
        } else {
            super.readPropertyValueFromXMLElement(aPropXmlInfo, aElement, aParser, aOptions);
        }
    }

    @Override
    public void buildFromXMLElement(Element aElement, XMLParser aParser, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        super.buildFromXMLElement(aElement, aParser, aOptions);
        if (this.getAnalysisEngineMetaData().getOperationalProperties() == null) {
            OperationalProperties opProps = UIMAFramework.getResourceSpecifierFactory().createOperationalProperties();
            opProps.setModifiesCas(true);
            opProps.setMultipleDeploymentAllowed(true);
            this.getAnalysisEngineMetaData().setOperationalProperties(opProps);
        }
    }

    @Override
    protected XmlizationInfo getXmlizationInfo() {
        return XMLIZATION_INFO;
    }

    protected static XmlizationInfo getXmlizationInfoForClass() {
        return XMLIZATION_INFO;
    }
}

