/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mail;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.DecoderUtil;
import org.apache.james.mime4j.dom.address.Address;
import org.apache.james.mime4j.dom.address.AddressList;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.dom.address.MailboxList;
import org.apache.james.mime4j.dom.field.AddressListField;
import org.apache.james.mime4j.dom.field.DateTimeField;
import org.apache.james.mime4j.dom.field.MailboxListField;
import org.apache.james.mime4j.dom.field.ParsedField;
import org.apache.james.mime4j.dom.field.UnstructuredField;
import org.apache.james.mime4j.field.LenientFieldParser;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.Field;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Message;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.mail.MailUtil;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.DateUtils;
import org.xml.sax.SAXException;

class MailContentHandler
implements ContentHandler {
    private static final Pattern GENERAL_TIME_ZONE_NO_MINUTES_PATTERN = Pattern.compile("(?:UTC|GMT)([+-])(\\d?\\d)\\Z");
    private static final Pattern AM_PM = Pattern.compile("(?i)(\\d)([ap]m)\\b");
    private static final DateFormat[] ALTERNATE_DATE_FORMATS = new DateFormat[]{MailContentHandler.createDateFormat("MMM dd yy hh:mm a", null), MailContentHandler.createDateFormat("EEE d MMM yy HH:mm:ss Z", DateUtils.UTC), MailContentHandler.createDateFormat("EEE d MMM yy HH:mm:ss z", DateUtils.UTC), MailContentHandler.createDateFormat("EEE d MMM yy HH:mm:ss", null), MailContentHandler.createDateFormat("EEEEE MMM d yy hh:mm a", null), MailContentHandler.createDateFormat("d MMM yy 'at' HH:mm:ss z", DateUtils.UTC), MailContentHandler.createDateFormat("yy-MM-dd HH:mm:ss", null), MailContentHandler.createDateFormat("MM/dd/yy hh:mm a", null, false), MailContentHandler.createDateFormat("MMM d yy", DateUtils.MIDDAY, false), MailContentHandler.createDateFormat("EEE d MMM yy", DateUtils.MIDDAY, false), MailContentHandler.createDateFormat("d MMM yy", DateUtils.MIDDAY, false), MailContentHandler.createDateFormat("yy/MM/dd", DateUtils.MIDDAY, false), MailContentHandler.createDateFormat("MM/dd/yy", DateUtils.MIDDAY, false)};
    private boolean strictParsing = false;
    private XHTMLContentHandler handler;
    private Metadata metadata;
    private EmbeddedDocumentExtractor extractor;
    private boolean inPart = false;

    private static DateFormat createDateFormat(String format, TimeZone timezone) {
        return MailContentHandler.createDateFormat(format, timezone, true);
    }

    private static DateFormat createDateFormat(String format, TimeZone timezone, boolean isLenient) {
        SimpleDateFormat sdf = new SimpleDateFormat(format, new DateFormatSymbols(Locale.US));
        if (timezone != null) {
            sdf.setTimeZone(timezone);
        }
        sdf.setLenient(isLenient);
        return sdf;
    }

    MailContentHandler(XHTMLContentHandler xhtml, Metadata metadata, ParseContext context, boolean strictParsing) {
        this.handler = xhtml;
        this.metadata = metadata;
        this.strictParsing = strictParsing;
        this.extractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor((ParseContext)context);
    }

    public void body(BodyDescriptor body, InputStream is) throws MimeException, IOException {
        Metadata submd = new Metadata();
        submd.set("Content-Type", body.getMimeType());
        submd.set("Content-Encoding", body.getCharset());
        try {
            if (this.extractor.shouldParseEmbedded(submd)) {
                TikaInputStream tis = TikaInputStream.get((InputStream)is);
                this.extractor.parseEmbedded((InputStream)tis, (org.xml.sax.ContentHandler)this.handler, submd, false);
            }
        }
        catch (SAXException e) {
            throw new MimeException((Throwable)e);
        }
    }

    public void endBodyPart() throws MimeException {
        try {
            this.handler.endElement("p");
            this.handler.endElement("div");
        }
        catch (SAXException e) {
            throw new MimeException((Throwable)e);
        }
    }

    public void endHeader() throws MimeException {
    }

    public void startMessage() throws MimeException {
        try {
            this.handler.startDocument();
        }
        catch (SAXException e) {
            throw new MimeException((Throwable)e);
        }
    }

    public void endMessage() throws MimeException {
        try {
            this.handler.endDocument();
        }
        catch (SAXException e) {
            throw new MimeException((Throwable)e);
        }
    }

    public void endMultipart() throws MimeException {
        this.inPart = false;
    }

    public void epilogue(InputStream is) throws MimeException, IOException {
    }

    public void field(Field field) throws MimeException {
        block21: {
            if (this.inPart) {
                return;
            }
            try {
                String fieldname = field.getName();
                ParsedField parsedField = LenientFieldParser.getParser().parse(field, DecodeMonitor.SILENT);
                if (fieldname.equalsIgnoreCase("From")) {
                    MailboxListField fromField = (MailboxListField)parsedField;
                    MailboxList mailboxList = fromField.getMailboxList();
                    if (fromField.isValidField() && mailboxList != null) {
                        for (Address address : mailboxList) {
                            String from = this.getDisplayString(address);
                            MailUtil.setPersonAndEmail(from, Message.MESSAGE_FROM_NAME, Message.MESSAGE_FROM_EMAIL, this.metadata);
                            this.metadata.add("Message-From", from);
                            this.metadata.add(TikaCoreProperties.CREATOR, from);
                        }
                    } else {
                        String from = this.stripOutFieldPrefix(field, "From:");
                        MailUtil.setPersonAndEmail(from, Message.MESSAGE_FROM_NAME, Message.MESSAGE_FROM_EMAIL, this.metadata);
                        if (from.startsWith("<")) {
                            from = from.substring(1);
                        }
                        if (from.endsWith(">")) {
                            from = from.substring(0, from.length() - 1);
                        }
                        this.metadata.add("Message-From", from);
                        this.metadata.add(TikaCoreProperties.CREATOR, from);
                    }
                } else if (fieldname.equalsIgnoreCase("Subject")) {
                    this.metadata.set(TikaCoreProperties.TRANSITION_SUBJECT_TO_DC_TITLE, ((UnstructuredField)parsedField).getValue());
                } else if (fieldname.equalsIgnoreCase("To")) {
                    this.processAddressList(parsedField, "To:", "Message-To");
                } else if (fieldname.equalsIgnoreCase("CC")) {
                    this.processAddressList(parsedField, "Cc:", "Message-Cc");
                } else if (fieldname.equalsIgnoreCase("BCC")) {
                    this.processAddressList(parsedField, "Bcc:", "Message-Bcc");
                } else if (fieldname.equalsIgnoreCase("Date")) {
                    DateTimeField dateField = (DateTimeField)parsedField;
                    Date date = dateField.getDate();
                    if (date == null) {
                        date = MailContentHandler.tryOtherDateFormats(field.getBody());
                    }
                    this.metadata.set(TikaCoreProperties.CREATED, date);
                } else {
                    this.metadata.add("Message:Raw-Header:" + parsedField.getName(), field.getBody());
                }
            }
            catch (RuntimeException me) {
                if (!this.strictParsing) break block21;
                throw me;
            }
        }
    }

    private static synchronized Date tryOtherDateFormats(String text) {
        if (text == null) {
            return null;
        }
        text = text.replaceAll("\\s+", " ").trim();
        Matcher matcher = GENERAL_TIME_ZONE_NO_MINUTES_PATTERN.matcher(text = text.replaceAll(",", ""));
        if (matcher.find()) {
            text = matcher.replaceFirst("GMT$1$2:00");
        }
        if ((matcher = AM_PM.matcher(text)).find()) {
            text = matcher.replaceFirst("$1 $2");
        }
        for (DateFormat format : ALTERNATE_DATE_FORMATS) {
            try {
                return format.parse(text);
            }
            catch (ParseException parseException) {
            }
        }
        return null;
    }

    private void processAddressList(ParsedField field, String addressListType, String metadataField) throws MimeException {
        AddressListField toField = (AddressListField)field;
        if (toField.isValidField()) {
            AddressList addressList = toField.getAddressList();
            for (Address address : addressList) {
                this.metadata.add(metadataField, this.getDisplayString(address));
            }
        } else {
            String to = this.stripOutFieldPrefix((Field)field, addressListType);
            for (String eachTo : to.split(",")) {
                this.metadata.add(metadataField, eachTo.trim());
            }
        }
    }

    private String getDisplayString(Address address) {
        if (address instanceof Mailbox) {
            Mailbox mailbox = (Mailbox)address;
            String name = mailbox.getName();
            if (name != null && name.length() > 0) {
                name = DecoderUtil.decodeEncodedWords((String)name, (DecodeMonitor)DecodeMonitor.SILENT);
                return name + " <" + mailbox.getAddress() + ">";
            }
            return mailbox.getAddress();
        }
        return address.toString();
    }

    public void preamble(InputStream is) throws MimeException, IOException {
    }

    public void raw(InputStream is) throws MimeException, IOException {
    }

    public void startBodyPart() throws MimeException {
        try {
            this.handler.startElement("div", "class", "email-entry");
            this.handler.startElement("p");
        }
        catch (SAXException e) {
            throw new MimeException((Throwable)e);
        }
    }

    public void startHeader() throws MimeException {
    }

    public void startMultipart(BodyDescriptor descr) throws MimeException {
        this.inPart = true;
    }

    private String stripOutFieldPrefix(Field field, String fieldname) {
        String temp = field.getRaw().toString();
        int loc = fieldname.length();
        while (temp.charAt(loc) == ' ') {
            ++loc;
        }
        return temp.substring(loc);
    }
}

