/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.AllowConcurrentEvents;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.EventBus;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.Subscriber$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.Subscriber$SynchronizedSubscriber;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.SubscriberExceptionContext;
import com.google.j2objc.annotations.Weak;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

class Subscriber {
    @Weak
    private EventBus bus;
    final Object target;
    private final Method method;
    private final Executor executor;

    static Subscriber create(EventBus eventBus, Object object, Method method) {
        return Subscriber.isDeclaredThreadSafe(method) ? new Subscriber(eventBus, object, method) : new Subscriber$SynchronizedSubscriber(eventBus, object, method, null);
    }

    private Subscriber(EventBus eventBus, Object object, Method method) {
        this.bus = eventBus;
        this.target = Preconditions.checkNotNull(object);
        this.method = method;
        method.setAccessible(true);
        this.executor = eventBus.executor();
    }

    final void dispatchEvent(Object object) {
        this.executor.execute(new Subscriber$1(this, object));
    }

    void invokeSubscriberMethod(Object object) {
        try {
            this.method.invoke(this.target, Preconditions.checkNotNull(object));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Error("Method rejected target/argument: " + object, illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("Method became inaccessible: " + object, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof Error) {
                throw (Error)invocationTargetException.getCause();
            }
            throw invocationTargetException;
        }
    }

    private SubscriberExceptionContext context(Object object) {
        return new SubscriberExceptionContext(this.bus, object, this.target, this.method);
    }

    public final int hashCode() {
        return (31 + this.method.hashCode()) * 31 + System.identityHashCode(this.target);
    }

    public final boolean equals(@Nullable Object object) {
        if (object instanceof Subscriber) {
            Subscriber subscriber = (Subscriber)object;
            return this.target == subscriber.target && this.method.equals(subscriber.method);
        }
        return false;
    }

    private static boolean isDeclaredThreadSafe(Method method) {
        return method.getAnnotation(AllowConcurrentEvents.class) != null;
    }

    static /* synthetic */ SubscriberExceptionContext access$100(Subscriber subscriber, Object object) {
        return subscriber.context(object);
    }

    static /* synthetic */ EventBus access$200(Subscriber subscriber) {
        return subscriber.bus;
    }

    /* synthetic */ Subscriber(EventBus eventBus, Object object, Method method, Subscriber$1 subscriber$1) {
        this(eventBus, object, method);
    }
}

