/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.solr.search.facet.DoubleFuncSlotAcc;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.SlotAcc;

class AvgSlotAcc
extends DoubleFuncSlotAcc {
    int[] counts;

    public AvgSlotAcc(ValueSource values, FacetContext fcontext, int numSlots) {
        super(values, fcontext, numSlots);
        this.counts = new int[numSlots];
    }

    @Override
    public void reset() {
        super.reset();
        for (int i = 0; i < this.counts.length; ++i) {
            this.counts[i] = 0;
        }
    }

    @Override
    public void collect(int doc, int slotNum) throws IOException {
        double val = this.values.doubleVal(doc);
        if (val != 0.0 || this.values.exists(doc)) {
            int n = slotNum;
            this.result[n] = this.result[n] + val;
            int n2 = slotNum;
            this.counts[n2] = this.counts[n2] + 1;
        }
    }

    private double avg(double tot, int count) {
        return count == 0 ? 0.0 : tot / (double)count;
    }

    private double avg(int slot) {
        return this.avg(this.result[slot], this.counts[slot]);
    }

    @Override
    public int compare(int slotA, int slotB) {
        return Double.compare(this.avg(slotA), this.avg(slotB));
    }

    @Override
    public Object getValue(int slot) {
        if (this.fcontext.isShard()) {
            ArrayList<Number> lst = new ArrayList<Number>(2);
            lst.add(this.counts[slot]);
            lst.add(this.result[slot]);
            return lst;
        }
        return this.avg(slot);
    }

    @Override
    public void resize(SlotAcc.Resizer resizer) {
        super.resize(resizer);
        this.counts = resizer.resize(this.counts, 0);
    }
}

