/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.JSONWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.ReturnFields;

class ArrayOfNameTypeValueJSONWriter
extends JSONWriter {
    protected boolean writeTypeAndValueKey = false;
    private final boolean writeNullName;

    public ArrayOfNameTypeValueJSONWriter(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp, String wrapperFunction, String namedListStyle, boolean writeNullName) {
        super(writer, req, rsp, wrapperFunction, namedListStyle);
        this.writeNullName = writeNullName;
    }

    @Override
    public void writeNamedList(String name, NamedList val) throws IOException {
        if (val instanceof SimpleOrderedMap) {
            super.writeNamedList(name, val);
            return;
        }
        int sz = val.size();
        this.indent();
        this.writeArrayOpener(sz);
        this.incLevel();
        boolean first = true;
        for (int i = 0; i < sz; ++i) {
            if (first) {
                first = false;
            } else {
                this.writeArraySeparator();
            }
            this.indent();
            String elementName = val.getName(i);
            Object elementVal = val.getVal(i);
            this.writeMapOpener(-1);
            if (elementName != null || this.writeNullName) {
                this.writeKey("name", false);
                this.writeVal("name", elementName);
                this.writeMapSeparator();
            }
            this.writeTypeAndValueKey = true;
            this.writeVal(null, elementVal);
            if (this.writeTypeAndValueKey) {
                throw new RuntimeException("writeTypeAndValueKey should have been reset to false by writeVal('" + elementName + "','" + elementVal + "')");
            }
            this.writeMapCloser();
        }
        this.decLevel();
        this.writeArrayCloser();
    }

    protected void ifNeededWriteTypeAndValueKey(String type) throws IOException {
        if (this.writeTypeAndValueKey) {
            this.writeTypeAndValueKey = false;
            this.writeKey("type", false);
            this.writeVal("type", type);
            this.writeMapSeparator();
            this.writeKey("value", false);
        }
    }

    @Override
    public void writeInt(String name, String val) throws IOException {
        this.ifNeededWriteTypeAndValueKey("int");
        super.writeInt(name, val);
    }

    @Override
    public void writeLong(String name, String val) throws IOException {
        this.ifNeededWriteTypeAndValueKey("long");
        super.writeLong(name, val);
    }

    @Override
    public void writeFloat(String name, String val) throws IOException {
        this.ifNeededWriteTypeAndValueKey("float");
        super.writeFloat(name, val);
    }

    @Override
    public void writeDouble(String name, String val) throws IOException {
        this.ifNeededWriteTypeAndValueKey("double");
        super.writeDouble(name, val);
    }

    @Override
    public void writeBool(String name, String val) throws IOException {
        this.ifNeededWriteTypeAndValueKey("bool");
        super.writeBool(name, val);
    }

    @Override
    public void writeDate(String name, String val) throws IOException {
        this.ifNeededWriteTypeAndValueKey("date");
        super.writeDate(name, val);
    }

    @Override
    public void writeStr(String name, String val, boolean needsEscaping) throws IOException {
        this.ifNeededWriteTypeAndValueKey("str");
        super.writeStr(name, val, needsEscaping);
    }

    @Override
    public void writeSolrDocument(String name, SolrDocument doc, ReturnFields returnFields, int idx) throws IOException {
        this.ifNeededWriteTypeAndValueKey("doc");
        super.writeSolrDocument(name, doc, returnFields, idx);
    }

    @Override
    public void writeStartDocumentList(String name, long start, int size, long numFound, Float maxScore) throws IOException {
        this.ifNeededWriteTypeAndValueKey("doclist");
        super.writeStartDocumentList(name, start, size, numFound, maxScore);
    }

    @Override
    public void writeMap(String name, Map val, boolean excludeOuter, boolean isFirstVal) throws IOException {
        this.ifNeededWriteTypeAndValueKey("map");
        super.writeMap(name, val, excludeOuter, isFirstVal);
    }

    @Override
    public void writeArray(String name, Iterator val) throws IOException {
        this.ifNeededWriteTypeAndValueKey("array");
        super.writeArray(name, val);
    }

    @Override
    public void writeNull(String name) throws IOException {
        this.ifNeededWriteTypeAndValueKey("null");
        super.writeNull(name);
    }
}

