/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Map;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.cloud.autoscaling.ActionContext;
import org.apache.solr.cloud.autoscaling.TriggerActionBase;
import org.apache.solr.cloud.autoscaling.TriggerEvent;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.CollectionParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputePlanAction
extends TriggerActionBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void process(TriggerEvent event, ActionContext context) throws Exception {
        log.debug("-- processing event: {} with context properties: {}", (Object)event, context.getProperties());
        SolrCloudManager cloudManager = context.getCloudManager();
        try {
            SolrRequest operation;
            AutoScalingConfig autoScalingConf = cloudManager.getDistribStateManager().getAutoScalingConfig();
            if (autoScalingConf.isEmpty()) {
                throw new Exception("Action: " + this.getName() + " executed but no policy is configured");
            }
            Policy policy = autoScalingConf.getPolicy();
            Policy.Session session = policy.createSession(cloudManager);
            Suggester suggester = this.getSuggester(session, event, cloudManager);
            while ((operation = suggester.getSuggestion()) != null) {
                log.info("Computed Plan: {}", (Object)operation.getParams());
                Map<String, Object> props = context.getProperties();
                props.compute("operations", (k, v) -> {
                    ArrayList<SolrRequest> operations = (ArrayList<SolrRequest>)v;
                    if (operations == null) {
                        operations = new ArrayList<SolrRequest>();
                    }
                    operations.add(operation);
                    return operations;
                });
                session = suggester.getSession();
                suggester = this.getSuggester(session, event, cloudManager);
            }
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected exception while processing event: " + event, (Throwable)e);
        }
    }

    protected Suggester getSuggester(Policy.Session session, TriggerEvent event, SolrCloudManager cloudManager) {
        Suggester suggester;
        switch (event.getEventType()) {
            case NODEADDED: {
                suggester = session.getSuggester(CollectionParams.CollectionAction.MOVEREPLICA).hint(Suggester.Hint.TARGET_NODE, event.getProperty("nodeNames"));
                log.debug("NODEADDED Created suggester with targetNode: {}", event.getProperty("nodeNames"));
                break;
            }
            case NODELOST: {
                suggester = session.getSuggester(CollectionParams.CollectionAction.MOVEREPLICA).hint(Suggester.Hint.SRC_NODE, event.getProperty("nodeNames"));
                log.debug("NODELOST Created suggester with srcNode: {}", event.getProperty("nodeNames"));
                break;
            }
            default: {
                throw new UnsupportedOperationException("No support for events other than nodeAdded and nodeLost, received: " + event.getEventType());
            }
        }
        return suggester;
    }
}

