/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.CloudSolrStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TupleStream
implements Closeable,
Serializable,
MapWriter {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long serialVersionUID = 1L;
    private UUID streamNodeId = UUID.randomUUID();

    public abstract void setStreamContext(StreamContext var1);

    public abstract List<TupleStream> children();

    public abstract void open() throws IOException;

    @Override
    public abstract void close() throws IOException;

    public abstract Tuple read() throws IOException;

    public abstract StreamComparator getStreamSort();

    public abstract Explanation toExplanation(StreamFactory var1) throws IOException;

    public int getCost() {
        return 0;
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        this.open();
        ew.put("docs", iw -> {
            try {
                Tuple tuple;
                while ((tuple = this.read()) != null) {
                    iw.add(tuple);
                    if (!tuple.EOF) continue;
                    this.close();
                    break;
                }
            }
            catch (Throwable e) {
                this.close();
                for (Throwable ex = e; ex != null; ex = ex.getCause()) {
                    String m = ex.getMessage();
                    if (m == null || !m.contains("Broken pipe")) continue;
                    throw new IgnoreException();
                }
                if (e instanceof IOException) {
                    throw e;
                }
                throw new IOException(e);
            }
        });
    }

    public UUID getStreamNodeId() {
        return this.streamNodeId;
    }

    public static List<String> getShards(String zkHost, String collection, StreamContext streamContext) throws IOException {
        Map shardsMap = null;
        ArrayList<String> shards = new ArrayList();
        if (streamContext != null) {
            shardsMap = (Map)streamContext.get("shards");
        }
        if (shardsMap != null) {
            shards = (List)shardsMap.get(collection);
        } else {
            CloudSolrClient cloudSolrClient = streamContext.getSolrClientCache().getCloudSolrClient(zkHost);
            ZkStateReader zkStateReader = cloudSolrClient.getZkStateReader();
            ClusterState clusterState = zkStateReader.getClusterState();
            Collection<Slice> slices = CloudSolrStream.getSlices(collection, zkStateReader, true);
            Set<String> liveNodes = clusterState.getLiveNodes();
            for (Slice slice : slices) {
                Collection<Replica> replicas = slice.getReplicas();
                ArrayList<Replica> shuffler = new ArrayList<Replica>();
                for (Replica replica : replicas) {
                    if (replica.getState() != Replica.State.ACTIVE || !liveNodes.contains(replica.getNodeName())) continue;
                    shuffler.add(replica);
                }
                Collections.shuffle(shuffler, new Random());
                Replica rep = (Replica)shuffler.get(0);
                ZkCoreNodeProps zkProps = new ZkCoreNodeProps(rep);
                String url = zkProps.getCoreUrl();
                shards.add(url);
            }
        }
        return shards;
    }

    public static class IgnoreException
    extends IOException {
        @Override
        public void printStackTrace(PrintWriter pw) {
            pw.print("Early Client Disconnect");
        }

        @Override
        public String getMessage() {
            return "Early Client Disconnect";
        }
    }
}

