/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class PowerEvaluator
extends RecursiveNumericEvaluator
implements TwoValueWorker {
    protected static final long serialVersionUID = 1L;

    public PowerEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (2 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting two values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object first, Object second) throws IOException {
        if (null == first || null == second) {
            return null;
        }
        BigDecimal value = (BigDecimal)first;
        BigDecimal exponent = (BigDecimal)second;
        return Math.pow(value.doubleValue(), exponent.doubleValue());
    }
}

