/*
 * Decompiled with CFR 0.152.
 */
package com.drew.tools;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.lang.StringUtil;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import com.drew.metadata.exif.ExifThumbnailDirectory;
import com.drew.metadata.file.FileMetadataDirectory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProcessAllImagesInFolderUtility {
    public static void main(String[] args) throws IOException, JpegProcessingException {
        ArrayList<String> directories = new ArrayList<String>();
        FileHandlerBase handler = null;
        PrintStream log = System.out;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equalsIgnoreCase("--text")) {
                handler = new TextFileOutputHandler();
                continue;
            }
            if (arg.equalsIgnoreCase("--markdown")) {
                handler = new MarkdownTableOutputHandler();
                continue;
            }
            if (arg.equalsIgnoreCase("--unknown")) {
                handler = new UnknownTagHandler();
                continue;
            }
            if (arg.equalsIgnoreCase("--log-file")) {
                if (i == args.length - 1) {
                    ProcessAllImagesInFolderUtility.printUsage();
                    System.exit(1);
                }
                log = new PrintStream(new FileOutputStream(args[++i], false), true);
                continue;
            }
            directories.add(arg);
        }
        if (directories.isEmpty()) {
            System.err.println("Expects one or more directories as arguments.");
            ProcessAllImagesInFolderUtility.printUsage();
            System.exit(1);
        }
        if (handler == null) {
            handler = new BasicFileHandler();
        }
        long start = System.nanoTime();
        for (String directory : directories) {
            ProcessAllImagesInFolderUtility.processDirectory(new File(directory), handler, "", log);
        }
        handler.onScanCompleted(log);
        System.out.println(String.format("Completed in %d ms", (System.nanoTime() - start) / 1000000L));
        if (log != System.out) {
            log.close();
        }
    }

    private static void printUsage() {
        System.out.println("Usage:");
        System.out.println();
        System.out.println("  java com.drew.tools.ProcessAllImagesInFolderUtility [--text|--markdown|--unknown] [--log-file <file-name>]");
    }

    private static void processDirectory(@NotNull File path, @NotNull FileHandler handler, @NotNull String relativePath, PrintStream log) {
        handler.onStartingDirectory(path);
        Object[] pathItems = path.list();
        if (pathItems == null) {
            return;
        }
        Arrays.sort(pathItems);
        for (Object pathItem : pathItems) {
            Metadata metadata;
            File file = new File(path, (String)pathItem);
            if (file.isDirectory()) {
                ProcessAllImagesInFolderUtility.processDirectory(file, handler, (String)(relativePath.length() == 0 ? pathItem : relativePath + "/" + (String)pathItem), log);
                continue;
            }
            if (!handler.shouldProcess(file)) continue;
            handler.onBeforeExtraction(file, log, relativePath);
            try {
                metadata = ImageMetadataReader.readMetadata(file);
            }
            catch (Throwable t) {
                handler.onExtractionError(file, t, log);
                continue;
            }
            handler.onExtractionSuccess(file, metadata, relativePath, log);
        }
    }

    static class BasicFileHandler
    extends FileHandlerBase {
        BasicFileHandler() {
        }

        public void onExtractionSuccess(@NotNull File file, @NotNull Metadata metadata, @NotNull String relativePath, @NotNull PrintStream log) {
            super.onExtractionSuccess(file, metadata, relativePath, log);
            for (Directory directory : metadata.getDirectories()) {
                directory.getName();
                for (Tag tag : directory.getTags()) {
                    tag.getTagName();
                    tag.getDescription();
                }
            }
        }
    }

    static class UnknownTagHandler
    extends FileHandlerBase {
        private HashMap<String, HashMap<Integer, Integer>> _occurrenceCountByTagByDirectory = new HashMap();

        UnknownTagHandler() {
        }

        public void onExtractionSuccess(@NotNull File file, @NotNull Metadata metadata, @NotNull String relativePath, @NotNull PrintStream log) {
            super.onExtractionSuccess(file, metadata, relativePath, log);
            for (Directory directory : metadata.getDirectories()) {
                for (Tag tag : directory.getTags()) {
                    Integer count;
                    if (tag.hasTagName()) continue;
                    HashMap<Integer, Integer> occurrenceCountByTag = this._occurrenceCountByTagByDirectory.get(directory.getName());
                    if (occurrenceCountByTag == null) {
                        occurrenceCountByTag = new HashMap();
                        this._occurrenceCountByTagByDirectory.put(directory.getName(), occurrenceCountByTag);
                    }
                    if ((count = occurrenceCountByTag.get(tag.getTagType())) == null) {
                        count = 0;
                        occurrenceCountByTag.put(tag.getTagType(), 0);
                    }
                    occurrenceCountByTag.put(tag.getTagType(), count + 1);
                }
            }
        }

        public void onScanCompleted(@NotNull PrintStream log) {
            super.onScanCompleted(log);
            for (Map.Entry<String, HashMap<Integer, Integer>> pair1 : this._occurrenceCountByTagByDirectory.entrySet()) {
                String directoryName = pair1.getKey();
                ArrayList<Map.Entry<Integer, Integer>> counts = new ArrayList<Map.Entry<Integer, Integer>>(pair1.getValue().entrySet());
                Collections.sort(counts, new Comparator<Map.Entry<Integer, Integer>>(){

                    @Override
                    public int compare(Map.Entry<Integer, Integer> o1, Map.Entry<Integer, Integer> o2) {
                        return o2.getValue().compareTo(o1.getValue());
                    }
                });
                for (Map.Entry entry : counts) {
                    Integer tagType = (Integer)entry.getKey();
                    Integer count = (Integer)entry.getValue();
                    log.format("%s, 0x%04X, %d\n", directoryName, tagType, count);
                }
            }
        }
    }

    static class MarkdownTableOutputHandler
    extends FileHandlerBase {
        private final Map<String, String> _extensionEquivalence = new HashMap<String, String>();
        private final Map<String, List<Row>> _rowListByExtension = new HashMap<String, List<Row>>();

        public MarkdownTableOutputHandler() {
            this._extensionEquivalence.put("jpeg", "jpg");
        }

        public void onExtractionSuccess(@NotNull File file, @NotNull Metadata metadata, @NotNull String relativePath, @NotNull PrintStream log) {
            List<Row> list;
            super.onExtractionSuccess(file, metadata, relativePath, log);
            String extension = this.getExtension(file);
            if (extension == null) {
                return;
            }
            if (this._extensionEquivalence.containsKey(extension = extension.toLowerCase())) {
                extension = this._extensionEquivalence.get(extension);
            }
            if ((list = this._rowListByExtension.get(extension)) == null) {
                list = new ArrayList<Row>();
                this._rowListByExtension.put(extension, list);
            }
            list.add(new Row(file, metadata, relativePath));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onScanCompleted(@NotNull PrintStream log) {
            super.onScanCompleted(log);
            FileOutputStream outputStream = null;
            PrintStream stream = null;
            try {
                outputStream = new FileOutputStream("../wiki/ImageDatabaseSummary.md", false);
                stream = new PrintStream(outputStream, false);
                this.writeOutput(stream);
                stream.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
                if (outputStream != null) {
                    try {
                        ((OutputStream)outputStream).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        private void writeOutput(@NotNull PrintStream stream) throws IOException {
            OutputStreamWriter writer = new OutputStreamWriter(stream);
            writer.write("# Image Database Summary\n\n");
            for (String extension : this._rowListByExtension.keySet()) {
                writer.write("## " + extension.toUpperCase() + " Files\n\n");
                writer.write("File|Manufacturer|Model|Dir Count|Exif?|Makernote|Thumbnail|All Data\n");
                writer.write("----|------------|-----|---------|-----|---------|---------|--------\n");
                List<Row> rows = this._rowListByExtension.get(extension);
                Collections.sort(rows, new Comparator<Row>(){

                    @Override
                    public int compare(Row o1, Row o2) {
                        int c1 = StringUtil.compare(o1.manufacturer, o2.manufacturer);
                        return c1 != 0 ? c1 : StringUtil.compare(o1.model, o2.model);
                    }
                });
                for (Row row : rows) {
                    writer.write(String.format("[%s](https://raw.githubusercontent.com/drewnoakes/metadata-extractor-images/master/%s/%s)|%s|%s|%d|%s|%s|%s|[metadata](https://raw.githubusercontent.com/drewnoakes/metadata-extractor-images/master/%s/metadata/%s.txt)\n", row.file.getName(), row.relativePath, StringUtil.urlEncode(row.file.getName()), row.manufacturer == null ? "" : row.manufacturer, row.model == null ? "" : row.model, row.metadata.getDirectoryCount(), row.exifVersion == null ? "" : row.exifVersion, row.makernote == null ? "" : row.makernote, row.thumbnail == null ? "" : row.thumbnail, row.relativePath, StringUtil.urlEncode(row.file.getName()).toLowerCase()));
                }
                ((Writer)writer).write(10);
            }
            ((Writer)writer).flush();
        }

        class Row {
            final File file;
            final Metadata metadata;
            @NotNull
            final String relativePath;
            @Nullable
            private String manufacturer;
            @Nullable
            private String model;
            @Nullable
            private String exifVersion;
            @Nullable
            private String thumbnail;
            @Nullable
            private String makernote;

            Row(@NotNull File file, @NotNull Metadata metadata, String relativePath) {
                this.file = file;
                this.metadata = metadata;
                this.relativePath = relativePath;
                ExifIFD0Directory ifd0Dir = metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
                ExifSubIFDDirectory subIfdDir = metadata.getFirstDirectoryOfType(ExifSubIFDDirectory.class);
                ExifThumbnailDirectory thumbDir = metadata.getFirstDirectoryOfType(ExifThumbnailDirectory.class);
                if (ifd0Dir != null) {
                    this.manufacturer = ifd0Dir.getDescription(271);
                    this.model = ifd0Dir.getDescription(272);
                }
                boolean hasMakernoteData = false;
                if (subIfdDir != null) {
                    this.exifVersion = subIfdDir.getDescription(36864);
                    hasMakernoteData = subIfdDir.containsTag(37500);
                }
                if (thumbDir != null) {
                    Integer width = thumbDir.getInteger(256);
                    Integer height = thumbDir.getInteger(257);
                    this.thumbnail = width != null && height != null ? String.format("Yes (%s x %s)", width, height) : "Yes";
                }
                for (Directory directory : metadata.getDirectories()) {
                    if (!directory.getClass().getName().contains("Makernote")) continue;
                    this.makernote = directory.getName().replace("Makernote", "").trim();
                }
                if (this.makernote == null) {
                    this.makernote = hasMakernoteData ? "(Unknown)" : "N/A";
                }
            }
        }
    }

    static class TextFileOutputHandler
    extends FileHandlerBase {
        private static final String NEW_LINE = "\n";

        TextFileOutputHandler() {
        }

        public void onStartingDirectory(@NotNull File directoryPath) {
            super.onStartingDirectory(directoryPath);
            File metadataDirectory = new File(directoryPath + "/metadata");
            if (metadataDirectory.exists()) {
                TextFileOutputHandler.deleteRecursively(metadataDirectory);
            }
        }

        private static void deleteRecursively(File directory) {
            if (!directory.isDirectory()) {
                throw new IllegalArgumentException("Must be a directory.");
            }
            if (directory.exists()) {
                for (String item : directory.list()) {
                    File file = new File(item);
                    if (file.isDirectory()) {
                        TextFileOutputHandler.deleteRecursively(file);
                        continue;
                    }
                    file.delete();
                }
            }
            directory.delete();
        }

        public void onBeforeExtraction(@NotNull File file, @NotNull PrintStream log, @NotNull String relativePath) {
            super.onBeforeExtraction(file, log, relativePath);
            log.print(file.getAbsoluteFile());
            log.print(NEW_LINE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onExtractionSuccess(@NotNull File file, @NotNull Metadata metadata, @NotNull String relativePath, @NotNull PrintStream log) {
            super.onExtractionSuccess(file, metadata, relativePath, log);
            try {
                PrintWriter writer = null;
                try {
                    writer = TextFileOutputHandler.openWriter(file);
                    if (metadata.hasErrors()) {
                        for (Directory directory : metadata.getDirectories()) {
                            if (!directory.hasErrors()) continue;
                            for (String error : directory.getErrors()) {
                                writer.format("[ERROR: %s] %s%s", directory.getName(), error, NEW_LINE);
                            }
                        }
                        writer.write(NEW_LINE);
                    }
                    for (Directory directory : metadata.getDirectories()) {
                        String directoryName = directory.getName();
                        for (Tag tag : directory.getTags()) {
                            String tagName = tag.getTagName();
                            String description = tag.getDescription();
                            if (description == null) {
                                description = "";
                            }
                            if (directory instanceof FileMetadataDirectory && tag.getTagType() == 3) {
                                description = "<omitted for regression testing as checkout dependent>";
                            }
                            writer.format("[%s - %s] %s = %s%s", directoryName, tag.getTagTypeHex(), tagName, description, NEW_LINE);
                        }
                        if (directory.getTagCount() == 0) continue;
                        writer.write(NEW_LINE);
                    }
                    TextFileOutputHandler.writeHierarchyLevel(metadata, writer, null, 0);
                    writer.write(NEW_LINE);
                }
                finally {
                    TextFileOutputHandler.closeWriter(writer);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private static void writeHierarchyLevel(@NotNull Metadata metadata, @NotNull PrintWriter writer, @Nullable Directory parent, int level) {
            int indent = 4;
            for (Directory child : metadata.getDirectories()) {
                if (parent == null ? child.getParent() != null : !parent.equals(child.getParent())) continue;
                for (int i = 0; i < level * 4; ++i) {
                    writer.write(32);
                }
                writer.write("- ");
                writer.write(child.getName());
                writer.write(NEW_LINE);
                TextFileOutputHandler.writeHierarchyLevel(metadata, writer, child, level + 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onExtractionError(@NotNull File file, @NotNull Throwable throwable, @NotNull PrintStream log) {
            super.onExtractionError(file, throwable, log);
            try {
                PrintWriter writer = null;
                try {
                    writer = TextFileOutputHandler.openWriter(file);
                    writer.write("EXCEPTION: " + throwable.getMessage() + NEW_LINE);
                    writer.write(NEW_LINE);
                }
                finally {
                    TextFileOutputHandler.closeWriter(writer);
                }
            }
            catch (IOException e) {
                log.printf("IO exception writing metadata file: %s%s", e.getMessage(), NEW_LINE);
            }
        }

        @NotNull
        private static PrintWriter openWriter(@NotNull File file) throws IOException {
            File metadataDir = new File(String.format("%s/metadata", file.getParent()));
            if (!metadataDir.exists()) {
                metadataDir.mkdir();
            }
            String outputPath = String.format("%s/metadata/%s.txt", file.getParent(), file.getName());
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputPath), "UTF-8");
            writer.write("FILE: " + file.getName() + NEW_LINE);
            writer.write(NEW_LINE);
            return new PrintWriter(writer);
        }

        private static void closeWriter(@Nullable Writer writer) throws IOException {
            if (writer != null) {
                writer.write("Generated using metadata-extractor\n");
                writer.write("https://drewnoakes.com/code/exif/\n");
                writer.flush();
                writer.close();
            }
        }
    }

    static abstract class FileHandlerBase
    implements FileHandler {
        private final Set<String> _supportedExtensions = new HashSet<String>(Arrays.asList("jpg", "jpeg", "png", "gif", "bmp", "ico", "webp", "pcx", "ai", "eps", "nef", "crw", "cr2", "orf", "arw", "raf", "srw", "x3f", "rw2", "rwl", "tif", "tiff", "psd", "dng"));
        private int _processedFileCount = 0;
        private int _exceptionCount = 0;
        private int _errorCount = 0;
        private long _processedByteCount = 0L;

        FileHandlerBase() {
        }

        public void onStartingDirectory(@NotNull File directoryPath) {
        }

        public boolean shouldProcess(@NotNull File file) {
            String extension = this.getExtension(file);
            return extension != null && this._supportedExtensions.contains(extension.toLowerCase());
        }

        public void onBeforeExtraction(@NotNull File file, @NotNull PrintStream log, @NotNull String relativePath) {
            ++this._processedFileCount;
            this._processedByteCount += file.length();
        }

        public void onExtractionError(@NotNull File file, @NotNull Throwable throwable, @NotNull PrintStream log) {
            ++this._exceptionCount;
            log.printf("\t[%s] %s\n", throwable.getClass().getName(), throwable.getMessage());
        }

        public void onExtractionSuccess(@NotNull File file, @NotNull Metadata metadata, @NotNull String relativePath, @NotNull PrintStream log) {
            if (metadata.hasErrors()) {
                log.print(file);
                log.print('\n');
                for (Directory directory : metadata.getDirectories()) {
                    if (!directory.hasErrors()) continue;
                    for (String error : directory.getErrors()) {
                        log.printf("\t[%s] %s\n", directory.getName(), error);
                        ++this._errorCount;
                    }
                }
            }
        }

        public void onScanCompleted(@NotNull PrintStream log) {
            if (this._processedFileCount > 0) {
                log.print(String.format("Processed %,d files (%,d bytes) with %,d exceptions and %,d file errors\n", this._processedFileCount, this._processedByteCount, this._exceptionCount, this._errorCount));
            }
        }

        @Nullable
        protected String getExtension(@NotNull File file) {
            String fileName = file.getName();
            int i = fileName.lastIndexOf(46);
            if (i == -1) {
                return null;
            }
            if (i == fileName.length() - 1) {
                return null;
            }
            return fileName.substring(i + 1);
        }
    }

    static interface FileHandler {
        public void onStartingDirectory(@NotNull File var1);

        public boolean shouldProcess(@NotNull File var1);

        public void onBeforeExtraction(@NotNull File var1, @NotNull PrintStream var2, @NotNull String var3);

        public void onExtractionSuccess(@NotNull File var1, @NotNull Metadata var2, @NotNull String var3, @NotNull PrintStream var4);

        public void onExtractionError(@NotNull File var1, @NotNull Throwable var2, @NotNull PrintStream var3);

        public void onScanCompleted(@NotNull PrintStream var1);
    }
}

