/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.concurrent.TimeUnit;
import org.apache.solr.common.util.SuppressForbidden;

public abstract class TimeSource {
    public static final TimeSource CURRENT_TIME = new CurrentTimeSource();
    public static final TimeSource NANO_TIME = new NanoTimeSource();

    public abstract long getTime();

    public static final class NanoTimeSource
    extends TimeSource {
        @Override
        public long getTime() {
            return System.nanoTime();
        }
    }

    public static final class CurrentTimeSource
    extends TimeSource {
        @Override
        @SuppressForbidden(reason="Needed to provide timestamps based on currentTimeMillis.")
        public long getTime() {
            return TimeUnit.NANOSECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }
    }
}

