/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import com.codahale.metrics.MetricRegistry;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Registry;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.SolrjNamedThreadFactory;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.update.UpdateShardHandlerConfig;
import org.apache.solr.util.stats.HttpClientMetricNameStrategy;
import org.apache.solr.util.stats.InstrumentedHttpRequestExecutor;
import org.apache.solr.util.stats.InstrumentedPoolingHttpClientConnectionManager;
import org.apache.solr.util.stats.MetricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateShardHandler
implements SolrMetricProducer,
SolrInfoBean {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ExecutorService updateExecutor = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new SolrjNamedThreadFactory("updateExecutor"));
    private ExecutorService recoveryExecutor;
    private final CloseableHttpClient client;
    private final InstrumentedPoolingHttpClientConnectionManager clientConnectionManager;
    private final InstrumentedHttpRequestExecutor httpRequestExecutor;
    private final Set<String> metricNames = ConcurrentHashMap.newKeySet();
    private MetricRegistry registry;

    public UpdateShardHandler(UpdateShardHandlerConfig cfg) {
        this.clientConnectionManager = new InstrumentedPoolingHttpClientConnectionManager((Registry<ConnectionSocketFactory>)HttpClientUtil.getSchemaRegisteryProvider().getSchemaRegistry());
        if (cfg != null) {
            this.clientConnectionManager.setMaxTotal(cfg.getMaxUpdateConnections());
            this.clientConnectionManager.setDefaultMaxPerRoute(cfg.getMaxUpdateConnectionsPerHost());
        }
        ModifiableSolrParams clientParams = new ModifiableSolrParams();
        if (cfg != null) {
            clientParams.set("socketTimeout", cfg.getDistributedSocketTimeout());
            clientParams.set("connTimeout", cfg.getDistributedConnectionTimeout());
        }
        HttpClientMetricNameStrategy metricNameStrategy = InstrumentedHttpRequestExecutor.KNOWN_METRIC_NAME_STRATEGIES.get("queryLessURLAndMethod");
        if (cfg != null && (metricNameStrategy = InstrumentedHttpRequestExecutor.KNOWN_METRIC_NAME_STRATEGIES.get(cfg.getMetricNameStrategy())) == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown metricNameStrategy: " + cfg.getMetricNameStrategy() + " found. Must be one of: " + InstrumentedHttpRequestExecutor.KNOWN_METRIC_NAME_STRATEGIES.keySet());
        }
        this.httpRequestExecutor = new InstrumentedHttpRequestExecutor(metricNameStrategy);
        this.client = HttpClientUtil.createClient((SolrParams)clientParams, (PoolingHttpClientConnectionManager)this.clientConnectionManager, (boolean)false, (HttpRequestExecutor)this.httpRequestExecutor);
        if (cfg != null) {
            clientParams.set("maxConnections", cfg.getMaxUpdateConnections());
            clientParams.set("maxConnectionsPerHost", cfg.getMaxUpdateConnectionsPerHost());
        }
        log.debug("Created UpdateShardHandler HTTP client with params: {}", (Object)clientParams);
        SolrjNamedThreadFactory recoveryThreadFactory = new SolrjNamedThreadFactory("recoveryExecutor");
        if (cfg != null && cfg.getMaxRecoveryThreads() > 0) {
            log.debug("Creating recoveryExecutor with pool size {}", (Object)cfg.getMaxRecoveryThreads());
            this.recoveryExecutor = ExecutorUtil.newMDCAwareFixedThreadPool((int)cfg.getMaxRecoveryThreads(), (ThreadFactory)recoveryThreadFactory);
        } else {
            log.debug("Creating recoveryExecutor with unbounded pool");
            this.recoveryExecutor = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)recoveryThreadFactory);
        }
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public void initializeMetrics(SolrMetricManager manager, String registryName, String scope) {
        this.registry = manager.registry(registryName);
        String expandedScope = SolrMetricManager.mkName(scope, this.getCategory().name());
        this.clientConnectionManager.initializeMetrics(manager, registryName, expandedScope);
        this.httpRequestExecutor.initializeMetrics(manager, registryName, expandedScope);
        this.updateExecutor = MetricUtils.instrumentedExecutorService(this.updateExecutor, this, this.registry, SolrMetricManager.mkName("updateExecutor", expandedScope, "threadPool"));
        this.recoveryExecutor = MetricUtils.instrumentedExecutorService(this.recoveryExecutor, this, this.registry, SolrMetricManager.mkName("recoveryExecutor", expandedScope, "threadPool"));
    }

    @Override
    public String getDescription() {
        return "Metrics tracked by UpdateShardHandler related to distributed updates and recovery";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.UPDATE;
    }

    @Override
    public Set<String> getMetricNames() {
        return this.metricNames;
    }

    @Override
    public MetricRegistry getMetricRegistry() {
        return this.registry;
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public ExecutorService getUpdateExecutor() {
        return this.updateExecutor;
    }

    public PoolingHttpClientConnectionManager getConnectionManager() {
        return this.clientConnectionManager;
    }

    public ExecutorService getRecoveryExecutor() {
        return this.recoveryExecutor;
    }

    public void close() {
        try {
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.updateExecutor);
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.recoveryExecutor);
        }
        catch (Exception e) {
            SolrException.log((Logger)log, (Throwable)e);
        }
        finally {
            HttpClientUtil.close((HttpClient)this.client);
            this.clientConnectionManager.close();
        }
    }
}

