/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.Writer;
import org.apache.solr.common.PushWriter;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.ArrayOfNameTypeValueJSONWriter;
import org.apache.solr.response.JSONWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;

public class JSONResponseWriter
implements QueryResponseWriter {
    public static String CONTENT_TYPE_JSON_UTF8 = "application/json; charset=UTF-8";
    private String contentType = CONTENT_TYPE_JSON_UTF8;

    @Override
    public void init(NamedList namedList) {
        String contentType = (String)namedList.get("content-type");
        if (contentType != null) {
            this.contentType = contentType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        SolrParams params = req.getParams();
        String wrapperFunction = params.get("json.wrf");
        String namedListStyle = params.get("json.nl", "flat").intern();
        try (JSONWriter w = namedListStyle.equals("arrntv") ? new ArrayOfNameTypeValueJSONWriter(writer, req, rsp, wrapperFunction, namedListStyle, true) : new JSONWriter(writer, req, rsp, wrapperFunction, namedListStyle);){
            w.writeResponse();
        }
    }

    @Override
    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        return this.contentType;
    }

    public static PushWriter getPushWriter(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) {
        return new JSONWriter(writer, req, rsp);
    }
}

