/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.sql;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SolrEnumerator
implements Enumerator<Object> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final TupleStream tupleStream;
    private final List<Map.Entry<String, Class>> fields;
    private Tuple current;
    private char sep = (char)31;

    SolrEnumerator(TupleStream tupleStream, List<Map.Entry<String, Class>> fields) {
        this.tupleStream = tupleStream;
        try {
            this.tupleStream.open();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.fields = fields;
        this.current = null;
    }

    public Object current() {
        if (this.fields.size() == 1) {
            return this.getter(this.current, this.fields.get(0));
        }
        Object[] row = new Object[this.fields.size()];
        for (int i = 0; i < this.fields.size(); ++i) {
            row[i] = this.getter(this.current, this.fields.get(i));
        }
        return row;
    }

    private Object getter(Tuple tuple, Map.Entry<String, Class> field) {
        Object val = tuple.get((Object)field.getKey());
        if (val == null) {
            return null;
        }
        Class clazz = field.getValue();
        if (clazz.equals(Long.class)) {
            if (val instanceof Double) {
                return this.getRealVal(val);
            }
            return val;
        }
        if (val instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)val;
            StringBuilder buf = new StringBuilder();
            for (Object o : arrayList) {
                buf.append(this.sep);
                buf.append(o.toString());
            }
            val = buf.toString();
        }
        return val;
    }

    private Object getRealVal(Object val) {
        if (val instanceof Double) {
            double doubleVal = (Double)val;
            if (doubleVal % 1.0 == 0.0 && doubleVal >= -9.223372036854776E18 && doubleVal <= 9.223372036854776E18) {
                return (long)doubleVal;
            }
            return doubleVal;
        }
        return val;
    }

    public boolean moveNext() {
        try {
            Tuple tuple = this.tupleStream.read();
            if (tuple.EOF) {
                return false;
            }
            this.current = tuple;
            return true;
        }
        catch (IOException e) {
            logger.error("IOException", (Throwable)e);
            return false;
        }
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        if (this.tupleStream != null) {
            try {
                this.tupleStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

