/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.solr.cloud.OverseerCollectionMessageHandler;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;

public class CreateAliasCmd
implements OverseerCollectionMessageHandler.Cmd {
    private final OverseerCollectionMessageHandler ocmh;

    public CreateAliasCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        String aliasName = message.getStr("name");
        List<String> canonicalCollectionList = this.parseCollectionsParameter(message.get("collections"));
        String canonicalCollectionsString = StrUtils.join(canonicalCollectionList, (char)',');
        ZkStateReader zkStateReader = this.ocmh.zkStateReader;
        this.validateAllCollectionsExistAndNoDups(canonicalCollectionList, zkStateReader);
        zkStateReader.aliasesHolder.applyModificationAndExportToZk(aliases -> aliases.cloneWithCollectionAlias(aliasName, canonicalCollectionsString));
        Thread.sleep(100L);
    }

    private void validateAllCollectionsExistAndNoDups(List<String> collectionList, ZkStateReader zkStateReader) {
        String collectionStr = StrUtils.join(collectionList, (char)',');
        if (new HashSet<String>(collectionList).size() != collectionList.size()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Can't create collection alias for collections='%s', since it contains duplicates", collectionStr));
        }
        ClusterState clusterState = zkStateReader.getClusterState();
        Set aliasNames = zkStateReader.getAliases().getCollectionAliasListMap().keySet();
        for (String collection : collectionList) {
            if (clusterState.getCollectionOrNull(collection) != null || aliasNames.contains(collection)) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Can't create collection alias for collections='%s', '%s' is not an existing collection or alias", collectionStr, collection));
        }
    }

    private List<String> parseCollectionsParameter(Object colls) {
        if (colls == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing collections param");
        }
        if (colls instanceof List) {
            return (List)colls;
        }
        return StrUtils.splitSmart((String)colls.toString(), (String)",", (boolean)true).stream().map(String::trim).collect(Collectors.toList());
    }
}

