/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.gitlab;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.tasks.config.BaseRepositoryEditor;
import com.intellij.tasks.gitlab.GitlabRepository;
import com.intellij.tasks.gitlab.model.GitlabProject;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.TaskUiUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitlabRepositoryEditor
extends BaseRepositoryEditor<GitlabRepository> {
    private JBLabel myProjectLabel;
    private ComboBox myProjectComboBox;

    public GitlabRepositoryEditor(Project project, GitlabRepository repository, Consumer<GitlabRepository> changeListener) {
        super(project, (BaseRepository)repository, changeListener);
        this.myPasswordLabel.setText("Token:");
        this.myUsernameLabel.setVisible(false);
        this.myUserNameText.setVisible(false);
        this.myTestButton.setEnabled(((GitlabRepository)this.myRepository).isConfigured());
        this.installListener((JComboBox)this.myProjectComboBox);
        UIUtil.invokeLaterIfNeeded(() -> this.initialize());
    }

    private void initialize() {
        GitlabProject currentProject = ((GitlabRepository)this.myRepository).getCurrentProject();
        if (currentProject != null && ((GitlabRepository)this.myRepository).isConfigured()) {
            new FetchProjectsTask().queue();
        }
    }

    @Nullable
    protected JComponent createCustomPanel() {
        this.myProjectLabel = new JBLabel("Project:", 4);
        this.myProjectComboBox = new ComboBox(300);
        this.myProjectComboBox.setRenderer(new TaskUiUtil.SimpleComboBoxRenderer("Set server URL and token first"));
        this.myProjectLabel.setLabelFor((Component)this.myProjectComboBox);
        return new FormBuilder().addLabeledComponent((JComponent)this.myProjectLabel, (JComponent)this.myProjectComboBox).getPanel();
    }

    public void setAnchor(@Nullable JComponent anchor) {
        super.setAnchor(anchor);
        this.myProjectLabel.setAnchor(anchor);
    }

    protected void afterTestConnection(boolean connectionSuccessful) {
        if (connectionSuccessful) {
            new FetchProjectsTask().queue();
        }
    }

    public void apply() {
        super.apply();
        ((GitlabRepository)this.myRepository).setCurrentProject((GitlabProject)this.myProjectComboBox.getSelectedItem());
        this.myTestButton.setEnabled(((GitlabRepository)this.myRepository).isConfigured());
    }

    private class FetchProjectsTask
    extends TaskUiUtil.ComboBoxUpdater<GitlabProject> {
        private FetchProjectsTask() {
            super(GitlabRepositoryEditor.this.myProject, "Downloading Gitlab projects...", (JComboBox)GitlabRepositoryEditor.this.myProjectComboBox);
        }

        @Override
        public GitlabProject getExtraItem() {
            return GitlabRepository.UNSPECIFIED_PROJECT;
        }

        @Override
        @Nullable
        public GitlabProject getSelectedItem() {
            return ((GitlabRepository)GitlabRepositoryEditor.this.myRepository).getCurrentProject();
        }

        @Override
        @NotNull
        protected List<GitlabProject> fetch(@NotNull ProgressIndicator indicator) throws Exception {
            if (indicator == null) {
                FetchProjectsTask.$$$reportNull$$$0(0);
            }
            List<GitlabProject> list = ((GitlabRepository)GitlabRepositoryEditor.this.myRepository).fetchProjects();
            if (list == null) {
                FetchProjectsTask.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/tasks/gitlab/GitlabRepositoryEditor$FetchProjectsTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/tasks/gitlab/GitlabRepositoryEditor$FetchProjectsTask";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fetch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fetch";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

